@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sqlvirtualmachine.kotlin.inputs

import com.pulumi.azurenative.sqlvirtualmachine.inputs.LoadBalancerConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A load balancer configuration for an availability group listener.
 * @property loadBalancerResourceId Resource id of the load balancer.
 * @property privateIpAddress Private IP address.
 * @property probePort Probe port.
 * @property publicIpAddressResourceId Resource id of the public IP.
 * @property sqlVirtualMachineInstances List of the SQL virtual machine instance resource id's that are enrolled into the availability group listener.
 */
public data class LoadBalancerConfigurationArgs(
    public val loadBalancerResourceId: Output<String>? = null,
    public val privateIpAddress: Output<PrivateIPAddressArgs>? = null,
    public val probePort: Output<Int>? = null,
    public val publicIpAddressResourceId: Output<String>? = null,
    public val sqlVirtualMachineInstances: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sqlvirtualmachine.inputs.LoadBalancerConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.sqlvirtualmachine.inputs.LoadBalancerConfigurationArgs =
        com.pulumi.azurenative.sqlvirtualmachine.inputs.LoadBalancerConfigurationArgs.builder()
            .loadBalancerResourceId(loadBalancerResourceId?.applyValue({ args0 -> args0 }))
            .privateIpAddress(privateIpAddress?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .probePort(probePort?.applyValue({ args0 -> args0 }))
            .publicIpAddressResourceId(publicIpAddressResourceId?.applyValue({ args0 -> args0 }))
            .sqlVirtualMachineInstances(
                sqlVirtualMachineInstances?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [LoadBalancerConfigurationArgs].
 */
@PulumiTagMarker
public class LoadBalancerConfigurationArgsBuilder internal constructor() {
    private var loadBalancerResourceId: Output<String>? = null

    private var privateIpAddress: Output<PrivateIPAddressArgs>? = null

    private var probePort: Output<Int>? = null

    private var publicIpAddressResourceId: Output<String>? = null

    private var sqlVirtualMachineInstances: Output<List<String>>? = null

    /**
     * @param value Resource id of the load balancer.
     */
    @JvmName("yhptkhaxlpptsynf")
    public suspend fun loadBalancerResourceId(`value`: Output<String>) {
        this.loadBalancerResourceId = value
    }

    /**
     * @param value Private IP address.
     */
    @JvmName("csnyyolyqpwgnxhp")
    public suspend fun privateIpAddress(`value`: Output<PrivateIPAddressArgs>) {
        this.privateIpAddress = value
    }

    /**
     * @param value Probe port.
     */
    @JvmName("yjhqeyvsfgjbafta")
    public suspend fun probePort(`value`: Output<Int>) {
        this.probePort = value
    }

    /**
     * @param value Resource id of the public IP.
     */
    @JvmName("fyeqqxcpjacyonog")
    public suspend fun publicIpAddressResourceId(`value`: Output<String>) {
        this.publicIpAddressResourceId = value
    }

    /**
     * @param value List of the SQL virtual machine instance resource id's that are enrolled into the availability group listener.
     */
    @JvmName("yjrbbnypdngmkbwb")
    public suspend fun sqlVirtualMachineInstances(`value`: Output<List<String>>) {
        this.sqlVirtualMachineInstances = value
    }

    @JvmName("vnquhdnkanahaeed")
    public suspend fun sqlVirtualMachineInstances(vararg values: Output<String>) {
        this.sqlVirtualMachineInstances = Output.all(values.asList())
    }

    /**
     * @param values List of the SQL virtual machine instance resource id's that are enrolled into the availability group listener.
     */
    @JvmName("awfvcfonnnucrmyb")
    public suspend fun sqlVirtualMachineInstances(values: List<Output<String>>) {
        this.sqlVirtualMachineInstances = Output.all(values)
    }

    /**
     * @param value Resource id of the load balancer.
     */
    @JvmName("akihftlmcbolsijq")
    public suspend fun loadBalancerResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerResourceId = mapped
    }

    /**
     * @param value Private IP address.
     */
    @JvmName("kkosakxfssigecxo")
    public suspend fun privateIpAddress(`value`: PrivateIPAddressArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIpAddress = mapped
    }

    /**
     * @param argument Private IP address.
     */
    @JvmName("ttvwdiyoitwobjhd")
    public suspend fun privateIpAddress(argument: suspend PrivateIPAddressArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateIPAddressArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.privateIpAddress = mapped
    }

    /**
     * @param value Probe port.
     */
    @JvmName("lqosovcyvvanwyel")
    public suspend fun probePort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.probePort = mapped
    }

    /**
     * @param value Resource id of the public IP.
     */
    @JvmName("lwfvhmgkuasqlbcn")
    public suspend fun publicIpAddressResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIpAddressResourceId = mapped
    }

    /**
     * @param value List of the SQL virtual machine instance resource id's that are enrolled into the availability group listener.
     */
    @JvmName("bctealciebwysswb")
    public suspend fun sqlVirtualMachineInstances(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlVirtualMachineInstances = mapped
    }

    /**
     * @param values List of the SQL virtual machine instance resource id's that are enrolled into the availability group listener.
     */
    @JvmName("wlespkayhgabteiw")
    public suspend fun sqlVirtualMachineInstances(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sqlVirtualMachineInstances = mapped
    }

    internal fun build(): LoadBalancerConfigurationArgs = LoadBalancerConfigurationArgs(
        loadBalancerResourceId = loadBalancerResourceId,
        privateIpAddress = privateIpAddress,
        probePort = probePort,
        publicIpAddressResourceId = publicIpAddressResourceId,
        sqlVirtualMachineInstances = sqlVirtualMachineInstances,
    )
}
