@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sqlvirtualmachine.kotlin.inputs

import com.pulumi.azurenative.sqlvirtualmachine.inputs.MultiSubnetIpConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Multi subnet ip configuration for an availability group listener.
 * @property privateIpAddress Private IP address.
 * @property sqlVirtualMachineInstance SQL virtual machine instance resource id that are enrolled into the availability group listener.
 */
public data class MultiSubnetIpConfigurationArgs(
    public val privateIpAddress: Output<PrivateIPAddressArgs>,
    public val sqlVirtualMachineInstance: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.sqlvirtualmachine.inputs.MultiSubnetIpConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.sqlvirtualmachine.inputs.MultiSubnetIpConfigurationArgs =
        com.pulumi.azurenative.sqlvirtualmachine.inputs.MultiSubnetIpConfigurationArgs.builder()
            .privateIpAddress(privateIpAddress.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sqlVirtualMachineInstance(sqlVirtualMachineInstance.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MultiSubnetIpConfigurationArgs].
 */
@PulumiTagMarker
public class MultiSubnetIpConfigurationArgsBuilder internal constructor() {
    private var privateIpAddress: Output<PrivateIPAddressArgs>? = null

    private var sqlVirtualMachineInstance: Output<String>? = null

    /**
     * @param value Private IP address.
     */
    @JvmName("mxlbdmdwqqodcojv")
    public suspend fun privateIpAddress(`value`: Output<PrivateIPAddressArgs>) {
        this.privateIpAddress = value
    }

    /**
     * @param value SQL virtual machine instance resource id that are enrolled into the availability group listener.
     */
    @JvmName("tqkycfqxmbrqwggq")
    public suspend fun sqlVirtualMachineInstance(`value`: Output<String>) {
        this.sqlVirtualMachineInstance = value
    }

    /**
     * @param value Private IP address.
     */
    @JvmName("mhpecqghkebhkanm")
    public suspend fun privateIpAddress(`value`: PrivateIPAddressArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateIpAddress = mapped
    }

    /**
     * @param argument Private IP address.
     */
    @JvmName("kdgckhgstymhbxfj")
    public suspend fun privateIpAddress(argument: suspend PrivateIPAddressArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateIPAddressArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.privateIpAddress = mapped
    }

    /**
     * @param value SQL virtual machine instance resource id that are enrolled into the availability group listener.
     */
    @JvmName("rigvvhqaewbrwmkd")
    public suspend fun sqlVirtualMachineInstance(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sqlVirtualMachineInstance = mapped
    }

    internal fun build(): MultiSubnetIpConfigurationArgs = MultiSubnetIpConfigurationArgs(
        privateIpAddress = privateIpAddress ?: throw PulumiNullFieldException("privateIpAddress"),
        sqlVirtualMachineInstance = sqlVirtualMachineInstance ?: throw
            PulumiNullFieldException("sqlVirtualMachineInstance"),
    )
}
