@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sqlvirtualmachine.kotlin.inputs

import com.pulumi.azurenative.sqlvirtualmachine.inputs.PrivateIPAddressArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A private IP address bound to the availability group listener.
 * @property ipAddress Private IP address bound to the availability group listener.
 * @property subnetResourceId Subnet used to include private IP.
 */
public data class PrivateIPAddressArgs(
    public val ipAddress: Output<String>? = null,
    public val subnetResourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sqlvirtualmachine.inputs.PrivateIPAddressArgs> {
    override fun toJava(): com.pulumi.azurenative.sqlvirtualmachine.inputs.PrivateIPAddressArgs =
        com.pulumi.azurenative.sqlvirtualmachine.inputs.PrivateIPAddressArgs.builder()
            .ipAddress(ipAddress?.applyValue({ args0 -> args0 }))
            .subnetResourceId(subnetResourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateIPAddressArgs].
 */
@PulumiTagMarker
public class PrivateIPAddressArgsBuilder internal constructor() {
    private var ipAddress: Output<String>? = null

    private var subnetResourceId: Output<String>? = null

    /**
     * @param value Private IP address bound to the availability group listener.
     */
    @JvmName("souaxtfupruckshy")
    public suspend fun ipAddress(`value`: Output<String>) {
        this.ipAddress = value
    }

    /**
     * @param value Subnet used to include private IP.
     */
    @JvmName("eiyplmwmtsuygxyi")
    public suspend fun subnetResourceId(`value`: Output<String>) {
        this.subnetResourceId = value
    }

    /**
     * @param value Private IP address bound to the availability group listener.
     */
    @JvmName("ytawgqlripiwpnbp")
    public suspend fun ipAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddress = mapped
    }

    /**
     * @param value Subnet used to include private IP.
     */
    @JvmName("dagwakdyodmrvkru")
    public suspend fun subnetResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetResourceId = mapped
    }

    internal fun build(): PrivateIPAddressArgs = PrivateIPAddressArgs(
        ipAddress = ipAddress,
        subnetResourceId = subnetResourceId,
    )
}
