@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sqlvirtualmachine.kotlin.inputs

import com.pulumi.azurenative.sqlvirtualmachine.inputs.SQLStorageSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Set disk storage settings for SQL Server.
 * @property defaultFilePath SQL Server default file path
 * @property luns Logical Unit Numbers for the disks.
 */
public data class SQLStorageSettingsArgs(
    public val defaultFilePath: Output<String>? = null,
    public val luns: Output<List<Int>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sqlvirtualmachine.inputs.SQLStorageSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.sqlvirtualmachine.inputs.SQLStorageSettingsArgs =
        com.pulumi.azurenative.sqlvirtualmachine.inputs.SQLStorageSettingsArgs.builder()
            .defaultFilePath(defaultFilePath?.applyValue({ args0 -> args0 }))
            .luns(luns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [SQLStorageSettingsArgs].
 */
@PulumiTagMarker
public class SQLStorageSettingsArgsBuilder internal constructor() {
    private var defaultFilePath: Output<String>? = null

    private var luns: Output<List<Int>>? = null

    /**
     * @param value SQL Server default file path
     */
    @JvmName("lnomnwdqgkttxten")
    public suspend fun defaultFilePath(`value`: Output<String>) {
        this.defaultFilePath = value
    }

    /**
     * @param value Logical Unit Numbers for the disks.
     */
    @JvmName("dtdtfncwrmdhkwol")
    public suspend fun luns(`value`: Output<List<Int>>) {
        this.luns = value
    }

    @JvmName("vrivmmxkfuietwmt")
    public suspend fun luns(vararg values: Output<Int>) {
        this.luns = Output.all(values.asList())
    }

    /**
     * @param values Logical Unit Numbers for the disks.
     */
    @JvmName("oskaosyvemuglqom")
    public suspend fun luns(values: List<Output<Int>>) {
        this.luns = Output.all(values)
    }

    /**
     * @param value SQL Server default file path
     */
    @JvmName("kfjyykdyorraneqa")
    public suspend fun defaultFilePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultFilePath = mapped
    }

    /**
     * @param value Logical Unit Numbers for the disks.
     */
    @JvmName("itferilxbgijgqlq")
    public suspend fun luns(`value`: List<Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.luns = mapped
    }

    /**
     * @param values Logical Unit Numbers for the disks.
     */
    @JvmName("mywaoobakhrbaaui")
    public suspend fun luns(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.luns = mapped
    }

    internal fun build(): SQLStorageSettingsArgs = SQLStorageSettingsArgs(
        defaultFilePath = defaultFilePath,
        luns = luns,
    )
}
