@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sqlvirtualmachine.kotlin.inputs

import com.pulumi.azurenative.sqlvirtualmachine.inputs.ScheduleArgs.builder
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.enums.AssessmentDayOfWeek
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dayOfWeek Day of the week to run assessment.
 * @property enable Enable or disable assessment schedule on SQL virtual machine.
 * @property monthlyOccurrence Occurrence of the DayOfWeek day within a month to schedule assessment. Takes values: 1,2,3,4 and -1. Use -1 for last DayOfWeek day of the month
 * @property startTime Time of the day in HH:mm format. Eg. 17:30
 * @property weeklyInterval Number of weeks to schedule between 2 assessment runs. Takes value from 1-6
 */
public data class ScheduleArgs(
    public val dayOfWeek: Output<AssessmentDayOfWeek>? = null,
    public val enable: Output<Boolean>? = null,
    public val monthlyOccurrence: Output<Int>? = null,
    public val startTime: Output<String>? = null,
    public val weeklyInterval: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sqlvirtualmachine.inputs.ScheduleArgs> {
    override fun toJava(): com.pulumi.azurenative.sqlvirtualmachine.inputs.ScheduleArgs =
        com.pulumi.azurenative.sqlvirtualmachine.inputs.ScheduleArgs.builder()
            .dayOfWeek(dayOfWeek?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enable(enable?.applyValue({ args0 -> args0 }))
            .monthlyOccurrence(monthlyOccurrence?.applyValue({ args0 -> args0 }))
            .startTime(startTime?.applyValue({ args0 -> args0 }))
            .weeklyInterval(weeklyInterval?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScheduleArgs].
 */
@PulumiTagMarker
public class ScheduleArgsBuilder internal constructor() {
    private var dayOfWeek: Output<AssessmentDayOfWeek>? = null

    private var enable: Output<Boolean>? = null

    private var monthlyOccurrence: Output<Int>? = null

    private var startTime: Output<String>? = null

    private var weeklyInterval: Output<Int>? = null

    /**
     * @param value Day of the week to run assessment.
     */
    @JvmName("khfwjjkqcqsmxxpf")
    public suspend fun dayOfWeek(`value`: Output<AssessmentDayOfWeek>) {
        this.dayOfWeek = value
    }

    /**
     * @param value Enable or disable assessment schedule on SQL virtual machine.
     */
    @JvmName("tkqbafoalangirtv")
    public suspend fun enable(`value`: Output<Boolean>) {
        this.enable = value
    }

    /**
     * @param value Occurrence of the DayOfWeek day within a month to schedule assessment. Takes values: 1,2,3,4 and -1. Use -1 for last DayOfWeek day of the month
     */
    @JvmName("kqtlmfdvtxyeeavh")
    public suspend fun monthlyOccurrence(`value`: Output<Int>) {
        this.monthlyOccurrence = value
    }

    /**
     * @param value Time of the day in HH:mm format. Eg. 17:30
     */
    @JvmName("siosghriyckiulft")
    public suspend fun startTime(`value`: Output<String>) {
        this.startTime = value
    }

    /**
     * @param value Number of weeks to schedule between 2 assessment runs. Takes value from 1-6
     */
    @JvmName("jsksqsgfubryhjss")
    public suspend fun weeklyInterval(`value`: Output<Int>) {
        this.weeklyInterval = value
    }

    /**
     * @param value Day of the week to run assessment.
     */
    @JvmName("pbiwyfyrecwjlorm")
    public suspend fun dayOfWeek(`value`: AssessmentDayOfWeek?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dayOfWeek = mapped
    }

    /**
     * @param value Enable or disable assessment schedule on SQL virtual machine.
     */
    @JvmName("cwcrjdgyqdsdmhlu")
    public suspend fun enable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enable = mapped
    }

    /**
     * @param value Occurrence of the DayOfWeek day within a month to schedule assessment. Takes values: 1,2,3,4 and -1. Use -1 for last DayOfWeek day of the month
     */
    @JvmName("veddiloxvhtywopr")
    public suspend fun monthlyOccurrence(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monthlyOccurrence = mapped
    }

    /**
     * @param value Time of the day in HH:mm format. Eg. 17:30
     */
    @JvmName("wqmclkcgwerurbyb")
    public suspend fun startTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startTime = mapped
    }

    /**
     * @param value Number of weeks to schedule between 2 assessment runs. Takes value from 1-6
     */
    @JvmName("rwrtorrbmhqcahhy")
    public suspend fun weeklyInterval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weeklyInterval = mapped
    }

    internal fun build(): ScheduleArgs = ScheduleArgs(
        dayOfWeek = dayOfWeek,
        enable = enable,
        monthlyOccurrence = monthlyOccurrence,
        startTime = startTime,
        weeklyInterval = weeklyInterval,
    )
}
