@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * Configure assessment for databases in your SQL virtual machine.
 * @property enable Enable or disable assessment feature on SQL virtual machine.
 * @property runImmediately Run assessment immediately on SQL virtual machine.
 * @property schedule Schedule for Assessment.
 */
public data class AssessmentSettingsResponse(
    public val enable: Boolean? = null,
    public val runImmediately: Boolean? = null,
    public val schedule: ScheduleResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.sqlvirtualmachine.outputs.AssessmentSettingsResponse):
            AssessmentSettingsResponse = AssessmentSettingsResponse(
            enable = javaType.enable().map({ args0 -> args0 }).orElse(null),
            runImmediately = javaType.runImmediately().map({ args0 -> args0 }).orElse(null),
            schedule = javaType.schedule().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.ScheduleResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
