@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A SQL virtual machine group.
 * @property clusterConfiguration Cluster type.
 * @property clusterManagerType Type of cluster manager: Windows Server Failover Cluster (WSFC), implied by the scale type of the group and the OS type.
 * @property id Resource ID.
 * @property location Resource location.
 * @property name Resource name.
 * @property provisioningState Provisioning state to track the async operation status.
 * @property scaleType Scale type.
 * @property sqlImageOffer SQL image offer. Examples may include SQL2016-WS2016, SQL2017-WS2016.
 * @property sqlImageSku SQL image sku.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property tags Resource tags.
 * @property type Resource type.
 * @property wsfcDomainProfile Cluster Active Directory domain profile.
 */
public data class GetSqlVirtualMachineGroupResult(
    public val clusterConfiguration: String,
    public val clusterManagerType: String,
    public val id: String,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val scaleType: String,
    public val sqlImageOffer: String? = null,
    public val sqlImageSku: String? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val wsfcDomainProfile: WsfcDomainProfileResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.sqlvirtualmachine.outputs.GetSqlVirtualMachineGroupResult):
            GetSqlVirtualMachineGroupResult = GetSqlVirtualMachineGroupResult(
            clusterConfiguration = javaType.clusterConfiguration(),
            clusterManagerType = javaType.clusterManagerType(),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            scaleType = javaType.scaleType(),
            sqlImageOffer = javaType.sqlImageOffer().map({ args0 -> args0 }).orElse(null),
            sqlImageSku = javaType.sqlImageSku().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            wsfcDomainProfile = javaType.wsfcDomainProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.WsfcDomainProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
