@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Set the server/instance-level settings for SQL Server.
 * @property collation SQL Server Collation.
 * @property isIfiEnabled SQL Server IFI.
 * @property isLpimEnabled SQL Server LPIM.
 * @property isOptimizeForAdHocWorkloadsEnabled SQL Server Optimize for Adhoc workloads.
 * @property maxDop SQL Server MAXDOP.
 * @property maxServerMemoryMB SQL Server maximum memory.
 * @property minServerMemoryMB SQL Server minimum memory.
 */
public data class SQLInstanceSettingsResponse(
    public val collation: String? = null,
    public val isIfiEnabled: Boolean? = null,
    public val isLpimEnabled: Boolean? = null,
    public val isOptimizeForAdHocWorkloadsEnabled: Boolean? = null,
    public val maxDop: Int? = null,
    public val maxServerMemoryMB: Int? = null,
    public val minServerMemoryMB: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.sqlvirtualmachine.outputs.SQLInstanceSettingsResponse):
            SQLInstanceSettingsResponse = SQLInstanceSettingsResponse(
            collation = javaType.collation().map({ args0 -> args0 }).orElse(null),
            isIfiEnabled = javaType.isIfiEnabled().map({ args0 -> args0 }).orElse(null),
            isLpimEnabled = javaType.isLpimEnabled().map({ args0 -> args0 }).orElse(null),
            isOptimizeForAdHocWorkloadsEnabled = javaType.isOptimizeForAdHocWorkloadsEnabled().map({ args0 ->
                args0
            }).orElse(null),
            maxDop = javaType.maxDop().map({ args0 -> args0 }).orElse(null),
            maxServerMemoryMB = javaType.maxServerMemoryMB().map({ args0 -> args0 }).orElse(null),
            minServerMemoryMB = javaType.minServerMemoryMB().map({ args0 -> args0 }).orElse(null),
        )
    }
}
