@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Set disk storage settings for SQL Server.
 * @property defaultFilePath SQL Server default file path
 * @property luns Logical Unit Numbers for the disks.
 */
public data class SQLStorageSettingsResponse(
    public val defaultFilePath: String? = null,
    public val luns: List<Int>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.sqlvirtualmachine.outputs.SQLStorageSettingsResponse):
            SQLStorageSettingsResponse = SQLStorageSettingsResponse(
            defaultFilePath = javaType.defaultFilePath().map({ args0 -> args0 }).orElse(null),
            luns = javaType.luns().map({ args0 -> args0 }),
        )
    }
}
