@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property dataFileCount SQL Server tempdb data file count
 * @property dataFileSize SQL Server tempdb data file size
 * @property dataGrowth SQL Server tempdb data file autoGrowth size
 * @property defaultFilePath SQL Server default file path
 * @property logFileSize SQL Server tempdb log file size
 * @property logGrowth SQL Server tempdb log file autoGrowth size
 * @property luns Logical Unit Numbers for the disks.
 * @property persistFolder SQL Server tempdb persist folder choice
 * @property persistFolderPath SQL Server tempdb persist folder location
 */
public data class SQLTempDbSettingsResponse(
    public val dataFileCount: Int? = null,
    public val dataFileSize: Int? = null,
    public val dataGrowth: Int? = null,
    public val defaultFilePath: String? = null,
    public val logFileSize: Int? = null,
    public val logGrowth: Int? = null,
    public val luns: List<Int>? = null,
    public val persistFolder: Boolean? = null,
    public val persistFolderPath: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.sqlvirtualmachine.outputs.SQLTempDbSettingsResponse):
            SQLTempDbSettingsResponse = SQLTempDbSettingsResponse(
            dataFileCount = javaType.dataFileCount().map({ args0 -> args0 }).orElse(null),
            dataFileSize = javaType.dataFileSize().map({ args0 -> args0 }).orElse(null),
            dataGrowth = javaType.dataGrowth().map({ args0 -> args0 }).orElse(null),
            defaultFilePath = javaType.defaultFilePath().map({ args0 -> args0 }).orElse(null),
            logFileSize = javaType.logFileSize().map({ args0 -> args0 }).orElse(null),
            logGrowth = javaType.logGrowth().map({ args0 -> args0 }).orElse(null),
            luns = javaType.luns().map({ args0 -> args0 }),
            persistFolder = javaType.persistFolder().map({ args0 -> args0 }).orElse(null),
            persistFolderPath = javaType.persistFolderPath().map({ args0 -> args0 }).orElse(null),
        )
    }
}
