@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property dayOfWeek Day of the week to run assessment.
 * @property enable Enable or disable assessment schedule on SQL virtual machine.
 * @property monthlyOccurrence Occurrence of the DayOfWeek day within a month to schedule assessment. Takes values: 1,2,3,4 and -1. Use -1 for last DayOfWeek day of the month
 * @property startTime Time of the day in HH:mm format. Eg. 17:30
 * @property weeklyInterval Number of weeks to schedule between 2 assessment runs. Takes value from 1-6
 */
public data class ScheduleResponse(
    public val dayOfWeek: String? = null,
    public val enable: Boolean? = null,
    public val monthlyOccurrence: Int? = null,
    public val startTime: String? = null,
    public val weeklyInterval: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.sqlvirtualmachine.outputs.ScheduleResponse):
            ScheduleResponse = ScheduleResponse(
            dayOfWeek = javaType.dayOfWeek().map({ args0 -> args0 }).orElse(null),
            enable = javaType.enable().map({ args0 -> args0 }).orElse(null),
            monthlyOccurrence = javaType.monthlyOccurrence().map({ args0 -> args0 }).orElse(null),
            startTime = javaType.startTime().map({ args0 -> args0 }).orElse(null),
            weeklyInterval = javaType.weeklyInterval().map({ args0 -> args0 }).orElse(null),
        )
    }
}
