@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin

import com.pulumi.azurenative.storage.BlobServicePropertiesArgs.builder
import com.pulumi.azurenative.storage.kotlin.inputs.ChangeFeedArgs
import com.pulumi.azurenative.storage.kotlin.inputs.ChangeFeedArgsBuilder
import com.pulumi.azurenative.storage.kotlin.inputs.CorsRulesArgs
import com.pulumi.azurenative.storage.kotlin.inputs.CorsRulesArgsBuilder
import com.pulumi.azurenative.storage.kotlin.inputs.DeleteRetentionPolicyArgs
import com.pulumi.azurenative.storage.kotlin.inputs.DeleteRetentionPolicyArgsBuilder
import com.pulumi.azurenative.storage.kotlin.inputs.LastAccessTimeTrackingPolicyArgs
import com.pulumi.azurenative.storage.kotlin.inputs.LastAccessTimeTrackingPolicyArgsBuilder
import com.pulumi.azurenative.storage.kotlin.inputs.RestorePolicyPropertiesArgs
import com.pulumi.azurenative.storage.kotlin.inputs.RestorePolicyPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The properties of a storage account’s Blob service.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2021-02-01.
 * Other available API versions: 2023-01-01.
 * ## Example Usage
 * ### BlobServicesPutAllowPermanentDelete
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blobServiceProperties = new AzureNative.Storage.BlobServiceProperties("blobServiceProperties", new()
 *     {
 *         AccountName = "sto8607",
 *         BlobServicesName = "default",
 *         DeleteRetentionPolicy = new AzureNative.Storage.Inputs.DeleteRetentionPolicyArgs
 *         {
 *             AllowPermanentDelete = true,
 *             Days = 300,
 *             Enabled = true,
 *         },
 *         IsVersioningEnabled = true,
 *         ResourceGroupName = "res4410",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewBlobServiceProperties(ctx, "blobServiceProperties", &storage.BlobServicePropertiesArgs{
 * 			AccountName:      pulumi.String("sto8607"),
 * 			BlobServicesName: pulumi.String("default"),
 * 			DeleteRetentionPolicy: &storage.DeleteRetentionPolicyArgs{
 * 				AllowPermanentDelete: pulumi.Bool(true),
 * 				Days:                 pulumi.Int(300),
 * 				Enabled:              pulumi.Bool(true),
 * 			},
 * 			IsVersioningEnabled: pulumi.Bool(true),
 * 			ResourceGroupName:   pulumi.String("res4410"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.BlobServiceProperties;
 * import com.pulumi.azurenative.storage.BlobServicePropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blobServiceProperties = new BlobServiceProperties("blobServiceProperties", BlobServicePropertiesArgs.builder()
 *             .accountName("sto8607")
 *             .blobServicesName("default")
 *             .deleteRetentionPolicy(Map.ofEntries(
 *                 Map.entry("allowPermanentDelete", true),
 *                 Map.entry("days", 300),
 *                 Map.entry("enabled", true)
 *             ))
 *             .isVersioningEnabled(true)
 *             .resourceGroupName("res4410")
 *             .build());
 *     }
 * }
 * ```
 * ### BlobServicesPutLastAccessTimeBasedTracking
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blobServiceProperties = new AzureNative.Storage.BlobServiceProperties("blobServiceProperties", new()
 *     {
 *         AccountName = "sto8607",
 *         BlobServicesName = "default",
 *         LastAccessTimeTrackingPolicy = new AzureNative.Storage.Inputs.LastAccessTimeTrackingPolicyArgs
 *         {
 *             BlobType = new[]
 *             {
 *                 "blockBlob",
 *             },
 *             Enable = true,
 *             Name = "AccessTimeTracking",
 *             TrackingGranularityInDays = 1,
 *         },
 *         ResourceGroupName = "res4410",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewBlobServiceProperties(ctx, "blobServiceProperties", &storage.BlobServicePropertiesArgs{
 * 			AccountName:      pulumi.String("sto8607"),
 * 			BlobServicesName: pulumi.String("default"),
 * 			LastAccessTimeTrackingPolicy: &storage.LastAccessTimeTrackingPolicyArgs{
 * 				BlobType: pulumi.StringArray{
 * 					pulumi.String("blockBlob"),
 * 				},
 * 				Enable:                    pulumi.Bool(true),
 * 				Name:                      pulumi.String("AccessTimeTracking"),
 * 				TrackingGranularityInDays: pulumi.Int(1),
 * 			},
 * 			ResourceGroupName: pulumi.String("res4410"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.BlobServiceProperties;
 * import com.pulumi.azurenative.storage.BlobServicePropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blobServiceProperties = new BlobServiceProperties("blobServiceProperties", BlobServicePropertiesArgs.builder()
 *             .accountName("sto8607")
 *             .blobServicesName("default")
 *             .lastAccessTimeTrackingPolicy(Map.ofEntries(
 *                 Map.entry("blobType", "blockBlob"),
 *                 Map.entry("enable", true),
 *                 Map.entry("name", "AccessTimeTracking"),
 *                 Map.entry("trackingGranularityInDays", 1)
 *             ))
 *             .resourceGroupName("res4410")
 *             .build());
 *     }
 * }
 * ```
 * ### PutBlobServices
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blobServiceProperties = new AzureNative.Storage.BlobServiceProperties("blobServiceProperties", new()
 *     {
 *         AccountName = "sto8607",
 *         BlobServicesName = "default",
 *         ChangeFeed = new AzureNative.Storage.Inputs.ChangeFeedArgs
 *         {
 *             Enabled = true,
 *             RetentionInDays = 7,
 *         },
 *         Cors = new AzureNative.Storage.Inputs.CorsRulesArgs
 *         {
 *             CorsRules = new[]
 *             {
 *                 new AzureNative.Storage.Inputs.CorsRuleArgs
 *                 {
 *                     AllowedHeaders = new[]
 *                     {
 *                         "x-ms-meta-abc",
 *                         "x-ms-meta-data*",
 *                         "x-ms-meta-target*",
 *                     },
 *                     AllowedMethods = new[]
 *                     {
 *                         "GET",
 *                         "HEAD",
 *                         "POST",
 *                         "OPTIONS",
 *                         "MERGE",
 *                         "PUT",
 *                     },
 *                     AllowedOrigins = new[]
 *                     {
 *                         "http://www.contoso.com",
 *                         "http://www.fabrikam.com",
 *                     },
 *                     ExposedHeaders = new[]
 *                     {
 *                         "x-ms-meta-*",
 *                     },
 *                     MaxAgeInSeconds = 100,
 *                 },
 *                 new AzureNative.Storage.Inputs.CorsRuleArgs
 *                 {
 *                     AllowedHeaders = new[]
 *                     {
 *                         "*",
 *                     },
 *                     AllowedMethods = new[]
 *                     {
 *                         "GET",
 *                     },
 *                     AllowedOrigins = new[]
 *                     {
 *                         "*",
 *                     },
 *                     ExposedHeaders = new[]
 *                     {
 *                         "*",
 *                     },
 *                     MaxAgeInSeconds = 2,
 *                 },
 *                 new AzureNative.Storage.Inputs.CorsRuleArgs
 *                 {
 *                     AllowedHeaders = new[]
 *                     {
 *                         "x-ms-meta-12345675754564*",
 *                     },
 *                     AllowedMethods = new[]
 *                     {
 *                         "GET",
 *                         "PUT",
 *                     },
 *                     AllowedOrigins = new[]
 *                     {
 *                         "http://www.abc23.com",
 *                         "https://www.fabrikam.com/*",
 *                     },
 *                     ExposedHeaders = new[]
 *                     {
 *                         "x-ms-meta-abc",
 *                         "x-ms-meta-data*",
 *                         "x -ms-meta-target*",
 *                     },
 *                     MaxAgeInSeconds = 2000,
 *                 },
 *             },
 *         },
 *         DefaultServiceVersion = "2017-07-29",
 *         DeleteRetentionPolicy = new AzureNative.Storage.Inputs.DeleteRetentionPolicyArgs
 *         {
 *             Days = 300,
 *             Enabled = true,
 *         },
 *         IsVersioningEnabled = true,
 *         ResourceGroupName = "res4410",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewBlobServiceProperties(ctx, "blobServiceProperties", &storage.BlobServicePropertiesArgs{
 * 			AccountName:      pulumi.String("sto8607"),
 * 			BlobServicesName: pulumi.String("default"),
 * 			ChangeFeed: &storage.ChangeFeedArgs{
 * 				Enabled:         pulumi.Bool(true),
 * 				RetentionInDays: pulumi.Int(7),
 * 			},
 * 			Cors: storage.CorsRulesResponse{
 * 				CorsRules: storage.CorsRuleArray{
 * 					&storage.CorsRuleArgs{
 * 						AllowedHeaders: pulumi.StringArray{
 * 							pulumi.String("x-ms-meta-abc"),
 * 							pulumi.String("x-ms-meta-data*"),
 * 							pulumi.String("x-ms-meta-target*"),
 * 						},
 * 						AllowedMethods: pulumi.StringArray{
 * 							pulumi.String("GET"),
 * 							pulumi.String("HEAD"),
 * 							pulumi.String("POST"),
 * 							pulumi.String("OPTIONS"),
 * 							pulumi.String("MERGE"),
 * 							pulumi.String("PUT"),
 * 						},
 * 						AllowedOrigins: pulumi.StringArray{
 * 							pulumi.String("http://www.contoso.com"),
 * 							pulumi.String("http://www.fabrikam.com"),
 * 						},
 * 						ExposedHeaders: pulumi.StringArray{
 * 							pulumi.String("x-ms-meta-*"),
 * 						},
 * 						MaxAgeInSeconds: pulumi.Int(100),
 * 					},
 * 					&storage.CorsRuleArgs{
 * 						AllowedHeaders: pulumi.StringArray{
 * 							pulumi.String("*"),
 * 						},
 * 						AllowedMethods: pulumi.StringArray{
 * 							pulumi.String("GET"),
 * 						},
 * 						AllowedOrigins: pulumi.StringArray{
 * 							pulumi.String("*"),
 * 						},
 * 						ExposedHeaders: pulumi.StringArray{
 * 							pulumi.String("*"),
 * 						},
 * 						MaxAgeInSeconds: pulumi.Int(2),
 * 					},
 * 					&storage.CorsRuleArgs{
 * 						AllowedHeaders: pulumi.StringArray{
 * 							pulumi.String("x-ms-meta-12345675754564*"),
 * 						},
 * 						AllowedMethods: pulumi.StringArray{
 * 							pulumi.String("GET"),
 * 							pulumi.String("PUT"),
 * 						},
 * 						AllowedOrigins: pulumi.StringArray{
 * 							pulumi.String("http://www.abc23.com"),
 * 							pulumi.String("https://www.fabrikam.com/*"),
 * 						},
 * 						ExposedHeaders: pulumi.StringArray{
 * 							pulumi.String("x-ms-meta-abc"),
 * 							pulumi.String("x-ms-meta-data*"),
 * 							pulumi.String("x -ms-meta-target*"),
 * 						},
 * 						MaxAgeInSeconds: pulumi.Int(2000),
 * 					},
 * 				},
 * 			},
 * 			DefaultServiceVersion: pulumi.String("2017-07-29"),
 * 			DeleteRetentionPolicy: &storage.DeleteRetentionPolicyArgs{
 * 				Days:    pulumi.Int(300),
 * 				Enabled: pulumi.Bool(true),
 * 			},
 * 			IsVersioningEnabled: pulumi.Bool(true),
 * 			ResourceGroupName:   pulumi.String("res4410"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.BlobServiceProperties;
 * import com.pulumi.azurenative.storage.BlobServicePropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blobServiceProperties = new BlobServiceProperties("blobServiceProperties", BlobServicePropertiesArgs.builder()
 *             .accountName("sto8607")
 *             .blobServicesName("default")
 *             .changeFeed(Map.ofEntries(
 *                 Map.entry("enabled", true),
 *                 Map.entry("retentionInDays", 7)
 *             ))
 *             .cors(Map.of("corsRules",
 *                 Map.ofEntries(
 *                     Map.entry("allowedHeaders",
 *                         "x-ms-meta-abc",
 *                         "x-ms-meta-data*",
 *                         "x-ms-meta-target*"),
 *                     Map.entry("allowedMethods",
 *                         "GET",
 *                         "HEAD",
 *                         "POST",
 *                         "OPTIONS",
 *                         "MERGE",
 *                         "PUT"),
 *                     Map.entry("allowedOrigins",
 *                         "http://www.contoso.com",
 *                         "http://www.fabrikam.com"),
 *                     Map.entry("exposedHeaders", "x-ms-meta-*"),
 *                     Map.entry("maxAgeInSeconds", 100)
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("allowedHeaders", "*"),
 *                     Map.entry("allowedMethods", "GET"),
 *                     Map.entry("allowedOrigins", "*"),
 *                     Map.entry("exposedHeaders", "*"),
 *                     Map.entry("maxAgeInSeconds", 2)
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("allowedHeaders", "x-ms-meta-12345675754564*"),
 *                     Map.entry("allowedMethods",
 *                         "GET",
 *                         "PUT"),
 *                     Map.entry("allowedOrigins",
 *                         "http://www.abc23.com",
 *                         "https://www.fabrikam.com/*"),
 *                     Map.entry("exposedHeaders",
 *                         "x-ms-meta-abc",
 *                         "x-ms-meta-data*",
 *                         "x -ms-meta-target*"),
 *                     Map.entry("maxAgeInSeconds", 2000)
 *                 )))
 *             .defaultServiceVersion("2017-07-29")
 *             .deleteRetentionPolicy(Map.ofEntries(
 *                 Map.entry("days", 300),
 *                 Map.entry("enabled", true)
 *             ))
 *             .isVersioningEnabled(true)
 *             .resourceGroupName("res4410")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storage:BlobServiceProperties default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/{BlobServicesName}
 * ```
 * @property accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
 * @property automaticSnapshotPolicyEnabled Deprecated in favor of isVersioningEnabled property.
 * @property blobServicesName The name of the blob Service within the specified storage account. Blob Service Name must be 'default'
 * @property changeFeed The blob service properties for change feed events.
 * @property containerDeleteRetentionPolicy The blob service properties for container soft delete.
 * @property cors Specifies CORS rules for the Blob service. You can include up to five CorsRule elements in the request. If no CorsRule elements are included in the request body, all CORS rules will be deleted, and CORS will be disabled for the Blob service.
 * @property defaultServiceVersion DefaultServiceVersion indicates the default version to use for requests to the Blob service if an incoming request’s version is not specified. Possible values include version 2008-10-27 and all more recent versions.
 * @property deleteRetentionPolicy The blob service properties for blob soft delete.
 * @property isVersioningEnabled Versioning is enabled if set to true.
 * @property lastAccessTimeTrackingPolicy The blob service property to configure last access time based tracking policy.
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 * @property restorePolicy The blob service properties for blob restore policy.
 * */*/*/
 */
public data class BlobServicePropertiesArgs(
    public val accountName: Output<String>? = null,
    public val automaticSnapshotPolicyEnabled: Output<Boolean>? = null,
    public val blobServicesName: Output<String>? = null,
    public val changeFeed: Output<ChangeFeedArgs>? = null,
    public val containerDeleteRetentionPolicy: Output<DeleteRetentionPolicyArgs>? = null,
    public val cors: Output<CorsRulesArgs>? = null,
    public val defaultServiceVersion: Output<String>? = null,
    public val deleteRetentionPolicy: Output<DeleteRetentionPolicyArgs>? = null,
    public val isVersioningEnabled: Output<Boolean>? = null,
    public val lastAccessTimeTrackingPolicy: Output<LastAccessTimeTrackingPolicyArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val restorePolicy: Output<RestorePolicyPropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.BlobServicePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.BlobServicePropertiesArgs =
        com.pulumi.azurenative.storage.BlobServicePropertiesArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .automaticSnapshotPolicyEnabled(automaticSnapshotPolicyEnabled?.applyValue({ args0 -> args0 }))
            .blobServicesName(blobServicesName?.applyValue({ args0 -> args0 }))
            .changeFeed(changeFeed?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .containerDeleteRetentionPolicy(
                containerDeleteRetentionPolicy?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .cors(cors?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .defaultServiceVersion(defaultServiceVersion?.applyValue({ args0 -> args0 }))
            .deleteRetentionPolicy(
                deleteRetentionPolicy?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .isVersioningEnabled(isVersioningEnabled?.applyValue({ args0 -> args0 }))
            .lastAccessTimeTrackingPolicy(
                lastAccessTimeTrackingPolicy?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .restorePolicy(restorePolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [BlobServicePropertiesArgs].
 */
@PulumiTagMarker
public class BlobServicePropertiesArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var automaticSnapshotPolicyEnabled: Output<Boolean>? = null

    private var blobServicesName: Output<String>? = null

    private var changeFeed: Output<ChangeFeedArgs>? = null

    private var containerDeleteRetentionPolicy: Output<DeleteRetentionPolicyArgs>? = null

    private var cors: Output<CorsRulesArgs>? = null

    private var defaultServiceVersion: Output<String>? = null

    private var deleteRetentionPolicy: Output<DeleteRetentionPolicyArgs>? = null

    private var isVersioningEnabled: Output<Boolean>? = null

    private var lastAccessTimeTrackingPolicy: Output<LastAccessTimeTrackingPolicyArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var restorePolicy: Output<RestorePolicyPropertiesArgs>? = null

    /**
     * @param value The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("minchbxypdibndep")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Deprecated in favor of isVersioningEnabled property.
     */
    @JvmName("cqjtvdjhfvydfmbs")
    public suspend fun automaticSnapshotPolicyEnabled(`value`: Output<Boolean>) {
        this.automaticSnapshotPolicyEnabled = value
    }

    /**
     * @param value The name of the blob Service within the specified storage account. Blob Service Name must be 'default'
     */
    @JvmName("frcbfuoiiwshnvhg")
    public suspend fun blobServicesName(`value`: Output<String>) {
        this.blobServicesName = value
    }

    /**
     * @param value The blob service properties for change feed events.
     */
    @JvmName("nccfdgosdfqedjdj")
    public suspend fun changeFeed(`value`: Output<ChangeFeedArgs>) {
        this.changeFeed = value
    }

    /**
     * @param value The blob service properties for container soft delete.
     */
    @JvmName("skvynvvwwsdnrkdt")
    public suspend fun containerDeleteRetentionPolicy(`value`: Output<DeleteRetentionPolicyArgs>) {
        this.containerDeleteRetentionPolicy = value
    }

    /**
     * @param value Specifies CORS rules for the Blob service. You can include up to five CorsRule elements in the request. If no CorsRule elements are included in the request body, all CORS rules will be deleted, and CORS will be disabled for the Blob service.
     */
    @JvmName("sbtwsnmkeiwepeak")
    public suspend fun cors(`value`: Output<CorsRulesArgs>) {
        this.cors = value
    }

    /**
     * @param value DefaultServiceVersion indicates the default version to use for requests to the Blob service if an incoming request’s version is not specified. Possible values include version 2008-10-27 and all more recent versions.
     */
    @JvmName("hxclcukivknnibhp")
    public suspend fun defaultServiceVersion(`value`: Output<String>) {
        this.defaultServiceVersion = value
    }

    /**
     * @param value The blob service properties for blob soft delete.
     */
    @JvmName("ekufgwninmsulicn")
    public suspend fun deleteRetentionPolicy(`value`: Output<DeleteRetentionPolicyArgs>) {
        this.deleteRetentionPolicy = value
    }

    /**
     * @param value Versioning is enabled if set to true.
     */
    @JvmName("rqgncmwumyujfmul")
    public suspend fun isVersioningEnabled(`value`: Output<Boolean>) {
        this.isVersioningEnabled = value
    }

    /**
     * @param value The blob service property to configure last access time based tracking policy.
     */
    @JvmName("kevxsrqkhuqqcwpi")
    public suspend
    fun lastAccessTimeTrackingPolicy(`value`: Output<LastAccessTimeTrackingPolicyArgs>) {
        this.lastAccessTimeTrackingPolicy = value
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("llqgnelqvlsamdar")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The blob service properties for blob restore policy.
     */
    @JvmName("fqejrbvbpdqpthcr")
    public suspend fun restorePolicy(`value`: Output<RestorePolicyPropertiesArgs>) {
        this.restorePolicy = value
    }

    /**
     * @param value The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("dnxeytacfhffimsd")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Deprecated in favor of isVersioningEnabled property.
     */
    @JvmName("kieimpddlermwmbl")
    public suspend fun automaticSnapshotPolicyEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.automaticSnapshotPolicyEnabled = mapped
    }

    /**
     * @param value The name of the blob Service within the specified storage account. Blob Service Name must be 'default'
     */
    @JvmName("cntaeojsgbagjurk")
    public suspend fun blobServicesName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blobServicesName = mapped
    }

    /**
     * @param value The blob service properties for change feed events.
     */
    @JvmName("umgmmpmxomliedga")
    public suspend fun changeFeed(`value`: ChangeFeedArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.changeFeed = mapped
    }

    /**
     * @param argument The blob service properties for change feed events.
     */
    @JvmName("gbwycigddpodpyuq")
    public suspend fun changeFeed(argument: suspend ChangeFeedArgsBuilder.() -> Unit) {
        val toBeMapped = ChangeFeedArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.changeFeed = mapped
    }

    /**
     * @param value The blob service properties for container soft delete.
     */
    @JvmName("utfyyypxgstcpibf")
    public suspend fun containerDeleteRetentionPolicy(`value`: DeleteRetentionPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerDeleteRetentionPolicy = mapped
    }

    /**
     * @param argument The blob service properties for container soft delete.
     */
    @JvmName("kyqlwfsxmqlasvwd")
    public suspend
    fun containerDeleteRetentionPolicy(argument: suspend DeleteRetentionPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = DeleteRetentionPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.containerDeleteRetentionPolicy = mapped
    }

    /**
     * @param value Specifies CORS rules for the Blob service. You can include up to five CorsRule elements in the request. If no CorsRule elements are included in the request body, all CORS rules will be deleted, and CORS will be disabled for the Blob service.
     */
    @JvmName("rsaqgkbaiffvemng")
    public suspend fun cors(`value`: CorsRulesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cors = mapped
    }

    /**
     * @param argument Specifies CORS rules for the Blob service. You can include up to five CorsRule elements in the request. If no CorsRule elements are included in the request body, all CORS rules will be deleted, and CORS will be disabled for the Blob service.
     */
    @JvmName("acldivisnxwhepxx")
    public suspend fun cors(argument: suspend CorsRulesArgsBuilder.() -> Unit) {
        val toBeMapped = CorsRulesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cors = mapped
    }

    /**
     * @param value DefaultServiceVersion indicates the default version to use for requests to the Blob service if an incoming request’s version is not specified. Possible values include version 2008-10-27 and all more recent versions.
     */
    @JvmName("mfkcjnvjtfkbnave")
    public suspend fun defaultServiceVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultServiceVersion = mapped
    }

    /**
     * @param value The blob service properties for blob soft delete.
     */
    @JvmName("beelmbqbqeckuydh")
    public suspend fun deleteRetentionPolicy(`value`: DeleteRetentionPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteRetentionPolicy = mapped
    }

    /**
     * @param argument The blob service properties for blob soft delete.
     */
    @JvmName("mehlsieucthdutbr")
    public suspend
    fun deleteRetentionPolicy(argument: suspend DeleteRetentionPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = DeleteRetentionPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.deleteRetentionPolicy = mapped
    }

    /**
     * @param value Versioning is enabled if set to true.
     */
    @JvmName("cggefiabfugpgujp")
    public suspend fun isVersioningEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isVersioningEnabled = mapped
    }

    /**
     * @param value The blob service property to configure last access time based tracking policy.
     */
    @JvmName("mqjwfytyabvopwtm")
    public suspend fun lastAccessTimeTrackingPolicy(`value`: LastAccessTimeTrackingPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastAccessTimeTrackingPolicy = mapped
    }

    /**
     * @param argument The blob service property to configure last access time based tracking policy.
     */
    @JvmName("dymljndjjehujesa")
    public suspend
    fun lastAccessTimeTrackingPolicy(argument: suspend LastAccessTimeTrackingPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = LastAccessTimeTrackingPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.lastAccessTimeTrackingPolicy = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("oxammvciqgqsmvlc")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The blob service properties for blob restore policy.
     */
    @JvmName("jtiqgbipvvjshchs")
    public suspend fun restorePolicy(`value`: RestorePolicyPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restorePolicy = mapped
    }

    /**
     * @param argument The blob service properties for blob restore policy.
     */
    @JvmName("ldggpgxpcqobqoua")
    public suspend
    fun restorePolicy(argument: suspend RestorePolicyPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = RestorePolicyPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.restorePolicy = mapped
    }

    internal fun build(): BlobServicePropertiesArgs = BlobServicePropertiesArgs(
        accountName = accountName,
        automaticSnapshotPolicyEnabled = automaticSnapshotPolicyEnabled,
        blobServicesName = blobServicesName,
        changeFeed = changeFeed,
        containerDeleteRetentionPolicy = containerDeleteRetentionPolicy,
        cors = cors,
        defaultServiceVersion = defaultServiceVersion,
        deleteRetentionPolicy = deleteRetentionPolicy,
        isVersioningEnabled = isVersioningEnabled,
        lastAccessTimeTrackingPolicy = lastAccessTimeTrackingPolicy,
        resourceGroupName = resourceGroupName,
        restorePolicy = restorePolicy,
    )
}
