@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin

import com.pulumi.azurenative.storage.kotlin.outputs.SignedIdentifierResponse
import com.pulumi.azurenative.storage.kotlin.outputs.SignedIdentifierResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [FileShare].
 */
@PulumiTagMarker
public class FileShareResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FileShareArgs = FileShareArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FileShareArgsBuilder.() -> Unit) {
        val builder = FileShareArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): FileShare {
        val builtJavaResource = com.pulumi.azurenative.storage.FileShare(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return FileShare(builtJavaResource)
    }
}

/**
 * Properties of the file share, including Id, resource name, resource type, Etag.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2021-02-01.
 * Other available API versions: 2023-01-01.
 * ## Example Usage
 * ### Create NFS Shares
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fileShare = new AzureNative.Storage.FileShare("fileShare", new()
 *     {
 *         AccountName = "sto666",
 *         EnabledProtocols = "NFS",
 *         ResourceGroupName = "res346",
 *         ShareName = "share1235",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewFileShare(ctx, "fileShare", &storage.FileShareArgs{
 * 			AccountName:       pulumi.String("sto666"),
 * 			EnabledProtocols:  pulumi.String("NFS"),
 * 			ResourceGroupName: pulumi.String("res346"),
 * 			ShareName:         pulumi.String("share1235"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.FileShare;
 * import com.pulumi.azurenative.storage.FileShareArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fileShare = new FileShare("fileShare", FileShareArgs.builder()
 *             .accountName("sto666")
 *             .enabledProtocols("NFS")
 *             .resourceGroupName("res346")
 *             .shareName("share1235")
 *             .build());
 *     }
 * }
 * ```
 * ### PutShares
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fileShare = new AzureNative.Storage.FileShare("fileShare", new()
 *     {
 *         AccountName = "sto328",
 *         ResourceGroupName = "res3376",
 *         ShareName = "share6185",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewFileShare(ctx, "fileShare", &storage.FileShareArgs{
 * 			AccountName:       pulumi.String("sto328"),
 * 			ResourceGroupName: pulumi.String("res3376"),
 * 			ShareName:         pulumi.String("share6185"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.FileShare;
 * import com.pulumi.azurenative.storage.FileShareArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fileShare = new FileShare("fileShare", FileShareArgs.builder()
 *             .accountName("sto328")
 *             .resourceGroupName("res3376")
 *             .shareName("share6185")
 *             .build());
 *     }
 * }
 * ```
 * ### PutShares with Access Tier
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fileShare = new AzureNative.Storage.FileShare("fileShare", new()
 *     {
 *         AccessTier = "Hot",
 *         AccountName = "sto666",
 *         ResourceGroupName = "res346",
 *         ShareName = "share1235",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewFileShare(ctx, "fileShare", &storage.FileShareArgs{
 * 			AccessTier:        pulumi.String("Hot"),
 * 			AccountName:       pulumi.String("sto666"),
 * 			ResourceGroupName: pulumi.String("res346"),
 * 			ShareName:         pulumi.String("share1235"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.FileShare;
 * import com.pulumi.azurenative.storage.FileShareArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fileShare = new FileShare("fileShare", FileShareArgs.builder()
 *             .accessTier("Hot")
 *             .accountName("sto666")
 *             .resourceGroupName("res346")
 *             .shareName("share1235")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storage:FileShare share1235 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/fileServices/default/shares/{shareName}
 * ```
 */
public class FileShare internal constructor(
    override val javaResource: com.pulumi.azurenative.storage.FileShare,
) : KotlinCustomResource(javaResource, FileShareMapper) {
    /**
     * Access tier for specific share. GpV2 account can choose between TransactionOptimized (default), Hot, and Cool. FileStorage account can choose Premium.
     */
    public val accessTier: Output<String>?
        get() = javaResource.accessTier().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates the last modification time for share access tier.
     */
    public val accessTierChangeTime: Output<String>
        get() = javaResource.accessTierChangeTime().applyValue({ args0 -> args0 })

    /**
     * Indicates if there is a pending transition for access tier.
     */
    public val accessTierStatus: Output<String>
        get() = javaResource.accessTierStatus().applyValue({ args0 -> args0 })

    /**
     * Indicates whether the share was deleted.
     */
    public val deleted: Output<Boolean>
        get() = javaResource.deleted().applyValue({ args0 -> args0 })

    /**
     * The deleted time if the share was deleted.
     */
    public val deletedTime: Output<String>
        get() = javaResource.deletedTime().applyValue({ args0 -> args0 })

    /**
     * The authentication protocol that is used for the file share. Can only be specified when creating a share.
     */
    public val enabledProtocols: Output<String>?
        get() = javaResource.enabledProtocols().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource Etag.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Returns the date and time the share was last modified.
     */
    public val lastModifiedTime: Output<String>
        get() = javaResource.lastModifiedTime().applyValue({ args0 -> args0 })

    /**
     * Specifies whether the lease on a share is of infinite or fixed duration, only when the share is leased.
     */
    public val leaseDuration: Output<String>
        get() = javaResource.leaseDuration().applyValue({ args0 -> args0 })

    /**
     * Lease state of the share.
     */
    public val leaseState: Output<String>
        get() = javaResource.leaseState().applyValue({ args0 -> args0 })

    /**
     * The lease status of the share.
     */
    public val leaseStatus: Output<String>
        get() = javaResource.leaseStatus().applyValue({ args0 -> args0 })

    /**
     * A name-value pair to associate with the share as metadata.
     */
    public val metadata: Output<Map<String, String>>?
        get() = javaResource.metadata().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Remaining retention days for share that was soft deleted.
     */
    public val remainingRetentionDays: Output<Int>
        get() = javaResource.remainingRetentionDays().applyValue({ args0 -> args0 })

    /**
     * The property is for NFS share only. The default is NoRootSquash.
     */
    public val rootSquash: Output<String>?
        get() = javaResource.rootSquash().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The maximum size of the share, in gigabytes. Must be greater than 0, and less than or equal to 5TB (5120). For Large File Shares, the maximum size is 102400.
     */
    public val shareQuota: Output<Int>?
        get() = javaResource.shareQuota().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The approximate size of the data stored on the share. Note that this value may not include all recently created or recently resized files.
     */
    public val shareUsageBytes: Output<Double>
        get() = javaResource.shareUsageBytes().applyValue({ args0 -> args0 })

    /**
     * List of stored access policies specified on the share.
     */
    public val signedIdentifiers: Output<List<SignedIdentifierResponse>>?
        get() = javaResource.signedIdentifiers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
            }).orElse(null)
        })

    /**
     * Creation time of share snapshot returned in the response of list shares with expand param "snapshots".
     */
    public val snapshotTime: Output<String>
        get() = javaResource.snapshotTime().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The version of the share.
     */
    public val version: Output<String>
        get() = javaResource.version().applyValue({ args0 -> args0 })
}

public object FileShareMapper : ResourceMapper<FileShare> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.storage.FileShare::class == javaResource::class

    override fun map(javaResource: Resource): FileShare = FileShare(
        javaResource as
            com.pulumi.azurenative.storage.FileShare,
    )
}

/**
 * @see [FileShare].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FileShare].
 */
public suspend fun fileShare(name: String, block: suspend FileShareResourceBuilder.() -> Unit):
    FileShare {
    val builder = FileShareResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FileShare].
 * @param name The _unique_ name of the resulting resource.
 */
public fun fileShare(name: String): FileShare {
    val builder = FileShareResourceBuilder()
    builder.name(name)
    return builder.build()
}
