@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin

import com.pulumi.azurenative.storage.QueueArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2021-02-01.
 * Other available API versions: 2023-01-01.
 * ## Example Usage
 * ### QueueOperationPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var queue = new AzureNative.Storage.Queue("queue", new()
 *     {
 *         AccountName = "sto328",
 *         QueueName = "queue6185",
 *         ResourceGroupName = "res3376",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewQueue(ctx, "queue", &storage.QueueArgs{
 * 			AccountName:       pulumi.String("sto328"),
 * 			QueueName:         pulumi.String("queue6185"),
 * 			ResourceGroupName: pulumi.String("res3376"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.Queue;
 * import com.pulumi.azurenative.storage.QueueArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var queue = new Queue("queue", QueueArgs.builder()
 *             .accountName("sto328")
 *             .queueName("queue6185")
 *             .resourceGroupName("res3376")
 *             .build());
 *     }
 * }
 * ```
 * ### QueueOperationPutWithMetadata
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var queue = new AzureNative.Storage.Queue("queue", new()
 *     {
 *         AccountName = "sto328",
 *         Metadata =
 *         {
 *             { "sample1", "meta1" },
 *             { "sample2", "meta2" },
 *         },
 *         QueueName = "queue6185",
 *         ResourceGroupName = "res3376",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewQueue(ctx, "queue", &storage.QueueArgs{
 * 			AccountName: pulumi.String("sto328"),
 * 			Metadata: pulumi.StringMap{
 * 				"sample1": pulumi.String("meta1"),
 * 				"sample2": pulumi.String("meta2"),
 * 			},
 * 			QueueName:         pulumi.String("queue6185"),
 * 			ResourceGroupName: pulumi.String("res3376"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.Queue;
 * import com.pulumi.azurenative.storage.QueueArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var queue = new Queue("queue", QueueArgs.builder()
 *             .accountName("sto328")
 *             .metadata(Map.ofEntries(
 *                 Map.entry("sample1", "meta1"),
 *                 Map.entry("sample2", "meta2")
 *             ))
 *             .queueName("queue6185")
 *             .resourceGroupName("res3376")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storage:Queue queue6185 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/queueServices/default/queues/{queueName}
 * ```
 * @property accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
 * @property metadata A name-value pair that represents queue metadata.
 * @property queueName A queue name must be unique within a storage account and must be between 3 and 63 characters.The name must comprise of lowercase alphanumeric and dash(-) characters only, it should begin and end with an alphanumeric character and it cannot have two consecutive dash(-) characters.
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 */
public data class QueueArgs(
    public val accountName: Output<String>? = null,
    public val metadata: Output<Map<String, String>>? = null,
    public val queueName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.QueueArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.QueueArgs =
        com.pulumi.azurenative.storage.QueueArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .metadata(
                metadata?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .queueName(queueName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [QueueArgs].
 */
@PulumiTagMarker
public class QueueArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var metadata: Output<Map<String, String>>? = null

    private var queueName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("wkicjqvjachuibmb")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value A name-value pair that represents queue metadata.
     */
    @JvmName("vqwhxuyggqqxxtjg")
    public suspend fun metadata(`value`: Output<Map<String, String>>) {
        this.metadata = value
    }

    /**
     * @param value A queue name must be unique within a storage account and must be between 3 and 63 characters.The name must comprise of lowercase alphanumeric and dash(-) characters only, it should begin and end with an alphanumeric character and it cannot have two consecutive dash(-) characters.
     */
    @JvmName("vgembapmsdslsogw")
    public suspend fun queueName(`value`: Output<String>) {
        this.queueName = value
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("jffowsuceqjdpcme")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("mldpqdmgdnqrwmyk")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value A name-value pair that represents queue metadata.
     */
    @JvmName("xirosrqxjfetidbi")
    public suspend fun metadata(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param values A name-value pair that represents queue metadata.
     */
    @JvmName("raumeqvvaavvdaxs")
    public fun metadata(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param value A queue name must be unique within a storage account and must be between 3 and 63 characters.The name must comprise of lowercase alphanumeric and dash(-) characters only, it should begin and end with an alphanumeric character and it cannot have two consecutive dash(-) characters.
     */
    @JvmName("atfnoydcibwketwx")
    public suspend fun queueName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queueName = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("aswuqiviafcscgjd")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): QueueArgs = QueueArgs(
        accountName = accountName,
        metadata = metadata,
        queueName = queueName,
        resourceGroupName = resourceGroupName,
    )
}
