@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin

import com.pulumi.azurenative.storage.StorageAccountArgs.builder
import com.pulumi.azurenative.storage.kotlin.enums.AccessTier
import com.pulumi.azurenative.storage.kotlin.enums.AllowedCopyScope
import com.pulumi.azurenative.storage.kotlin.enums.DnsEndpointType
import com.pulumi.azurenative.storage.kotlin.enums.Kind
import com.pulumi.azurenative.storage.kotlin.enums.LargeFileSharesState
import com.pulumi.azurenative.storage.kotlin.enums.MinimumTlsVersion
import com.pulumi.azurenative.storage.kotlin.enums.PublicNetworkAccess
import com.pulumi.azurenative.storage.kotlin.inputs.AzureFilesIdentityBasedAuthenticationArgs
import com.pulumi.azurenative.storage.kotlin.inputs.AzureFilesIdentityBasedAuthenticationArgsBuilder
import com.pulumi.azurenative.storage.kotlin.inputs.CustomDomainArgs
import com.pulumi.azurenative.storage.kotlin.inputs.CustomDomainArgsBuilder
import com.pulumi.azurenative.storage.kotlin.inputs.EncryptionArgs
import com.pulumi.azurenative.storage.kotlin.inputs.EncryptionArgsBuilder
import com.pulumi.azurenative.storage.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.storage.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.azurenative.storage.kotlin.inputs.IdentityArgs
import com.pulumi.azurenative.storage.kotlin.inputs.IdentityArgsBuilder
import com.pulumi.azurenative.storage.kotlin.inputs.ImmutableStorageAccountArgs
import com.pulumi.azurenative.storage.kotlin.inputs.ImmutableStorageAccountArgsBuilder
import com.pulumi.azurenative.storage.kotlin.inputs.KeyPolicyArgs
import com.pulumi.azurenative.storage.kotlin.inputs.KeyPolicyArgsBuilder
import com.pulumi.azurenative.storage.kotlin.inputs.NetworkRuleSetArgs
import com.pulumi.azurenative.storage.kotlin.inputs.NetworkRuleSetArgsBuilder
import com.pulumi.azurenative.storage.kotlin.inputs.RoutingPreferenceArgs
import com.pulumi.azurenative.storage.kotlin.inputs.RoutingPreferenceArgsBuilder
import com.pulumi.azurenative.storage.kotlin.inputs.SasPolicyArgs
import com.pulumi.azurenative.storage.kotlin.inputs.SasPolicyArgsBuilder
import com.pulumi.azurenative.storage.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.storage.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The storage account.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2021-02-01.
 * Other available API versions: 2015-05-01-preview, 2015-06-15, 2018-11-01, 2023-01-01.
 * ## Example Usage
 * ### NfsV3AccountCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageAccount = new AzureNative.Storage.StorageAccount("storageAccount", new()
 *     {
 *         AccountName = "sto4445",
 *         EnableHttpsTrafficOnly = false,
 *         EnableNfsV3 = true,
 *         IsHnsEnabled = true,
 *         Kind = "BlockBlobStorage",
 *         Location = "eastus",
 *         NetworkRuleSet = new AzureNative.Storage.Inputs.NetworkRuleSetArgs
 *         {
 *             Bypass = "AzureServices",
 *             DefaultAction = AzureNative.Storage.DefaultAction.Allow,
 *             IpRules = new() { },
 *             VirtualNetworkRules = new[]
 *             {
 *                 new AzureNative.Storage.Inputs.VirtualNetworkRuleArgs
 *                 {
 *                     VirtualNetworkResourceId = "/subscriptions/{subscription-id}/resourceGroups/res9101/providers/Microsoft.Network/virtualNetworks/net123/subnets/subnet12",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "res9101",
 *         Sku = new AzureNative.Storage.Inputs.SkuArgs
 *         {
 *             Name = "Premium_LRS",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewStorageAccount(ctx, "storageAccount", &storage.StorageAccountArgs{
 * 			AccountName:            pulumi.String("sto4445"),
 * 			EnableHttpsTrafficOnly: pulumi.Bool(false),
 * 			EnableNfsV3:            pulumi.Bool(true),
 * 			IsHnsEnabled:           pulumi.Bool(true),
 * 			Kind:                   pulumi.String("BlockBlobStorage"),
 * 			Location:               pulumi.String("eastus"),
 * 			NetworkRuleSet: storage.NetworkRuleSetResponse{
 * 				Bypass:        pulumi.String("AzureServices"),
 * 				DefaultAction: storage.DefaultActionAllow,
 * 				IpRules:       storage.IPRuleArray{},
 * 				VirtualNetworkRules: storage.VirtualNetworkRuleArray{
 * 					&storage.VirtualNetworkRuleArgs{
 * 						VirtualNetworkResourceId: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/res9101/providers/Microsoft.Network/virtualNetworks/net123/subnets/subnet12"),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("res9101"),
 * 			Sku: &storage.SkuArgs{
 * 				Name: pulumi.String("Premium_LRS"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.StorageAccount;
 * import com.pulumi.azurenative.storage.StorageAccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageAccount = new StorageAccount("storageAccount", StorageAccountArgs.builder()
 *             .accountName("sto4445")
 *             .enableHttpsTrafficOnly(false)
 *             .enableNfsV3(true)
 *             .isHnsEnabled(true)
 *             .kind("BlockBlobStorage")
 *             .location("eastus")
 *             .networkRuleSet(Map.ofEntries(
 *                 Map.entry("bypass", "AzureServices"),
 *                 Map.entry("defaultAction", "Allow"),
 *                 Map.entry("ipRules", ),
 *                 Map.entry("virtualNetworkRules", Map.of("virtualNetworkResourceId", "/subscriptions/{subscription-id}/resourceGroups/res9101/providers/Microsoft.Network/virtualNetworks/net123/subnets/subnet12"))
 *             ))
 *             .resourceGroupName("res9101")
 *             .sku(Map.of("name", "Premium_LRS"))
 *             .build());
 *     }
 * }
 * ```
 * ### StorageAccountCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageAccount = new AzureNative.Storage.StorageAccount("storageAccount", new()
 *     {
 *         AccountName = "sto4445",
 *         AllowBlobPublicAccess = false,
 *         AllowSharedKeyAccess = true,
 *         DefaultToOAuthAuthentication = false,
 *         Encryption = new AzureNative.Storage.Inputs.EncryptionArgs
 *         {
 *             KeySource = "Microsoft.Storage",
 *             RequireInfrastructureEncryption = false,
 *             Services = new AzureNative.Storage.Inputs.EncryptionServicesArgs
 *             {
 *                 Blob = new AzureNative.Storage.Inputs.EncryptionServiceArgs
 *                 {
 *                     Enabled = true,
 *                     KeyType = "Account",
 *                 },
 *                 File = new AzureNative.Storage.Inputs.EncryptionServiceArgs
 *                 {
 *                     Enabled = true,
 *                     KeyType = "Account",
 *                 },
 *             },
 *         },
 *         ExtendedLocation = new AzureNative.Storage.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "losangeles001",
 *             Type = "EdgeZone",
 *         },
 *         IsHnsEnabled = true,
 *         IsSftpEnabled = true,
 *         KeyPolicy = new AzureNative.Storage.Inputs.KeyPolicyArgs
 *         {
 *             KeyExpirationPeriodInDays = 20,
 *         },
 *         Kind = "Storage",
 *         Location = "eastus",
 *         MinimumTlsVersion = "TLS1_2",
 *         ResourceGroupName = "res9101",
 *         RoutingPreference = new AzureNative.Storage.Inputs.RoutingPreferenceArgs
 *         {
 *             PublishInternetEndpoints = true,
 *             PublishMicrosoftEndpoints = true,
 *             RoutingChoice = "MicrosoftRouting",
 *         },
 *         SasPolicy = new AzureNative.Storage.Inputs.SasPolicyArgs
 *         {
 *             ExpirationAction = "Log",
 *             SasExpirationPeriod = "1.15:59:59",
 *         },
 *         Sku = new AzureNative.Storage.Inputs.SkuArgs
 *         {
 *             Name = "Standard_GRS",
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *             { "key2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := storage.NewStorageAccount(ctx, "storageAccount", &storage.StorageAccountArgs{
 * AccountName: pulumi.String("sto4445"),
 * AllowBlobPublicAccess: pulumi.Bool(false),
 * AllowSharedKeyAccess: pulumi.Bool(true),
 * DefaultToOAuthAuthentication: pulumi.Bool(false),
 * Encryption: storage.EncryptionResponse{
 * KeySource: pulumi.String("Microsoft.Storage"),
 * RequireInfrastructureEncryption: pulumi.Bool(false),
 * Services: interface{}{
 * Blob: &storage.EncryptionServiceArgs{
 * Enabled: pulumi.Bool(true),
 * KeyType: pulumi.String("Account"),
 * },
 * File: &storage.EncryptionServiceArgs{
 * Enabled: pulumi.Bool(true),
 * KeyType: pulumi.String("Account"),
 * },
 * },
 * },
 * ExtendedLocation: &storage.ExtendedLocationArgs{
 * Name: pulumi.String("losangeles001"),
 * Type: pulumi.String("EdgeZone"),
 * },
 * IsHnsEnabled: pulumi.Bool(true),
 * IsSftpEnabled: pulumi.Bool(true),
 * KeyPolicy: &storage.KeyPolicyArgs{
 * KeyExpirationPeriodInDays: pulumi.Int(20),
 * },
 * Kind: pulumi.String("Storage"),
 * Location: pulumi.String("eastus"),
 * MinimumTlsVersion: pulumi.String("TLS1_2"),
 * ResourceGroupName: pulumi.String("res9101"),
 * RoutingPreference: &storage.RoutingPreferenceArgs{
 * PublishInternetEndpoints: pulumi.Bool(true),
 * PublishMicrosoftEndpoints: pulumi.Bool(true),
 * RoutingChoice: pulumi.String("MicrosoftRouting"),
 * },
 * SasPolicy: &storage.SasPolicyArgs{
 * ExpirationAction: pulumi.String("Log"),
 * SasExpirationPeriod: pulumi.String("1.15:59:59"),
 * },
 * Sku: &storage.SkuArgs{
 * Name: pulumi.String("Standard_GRS"),
 * },
 * Tags: pulumi.StringMap{
 * "key1": pulumi.String("value1"),
 * "key2": pulumi.String("value2"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.StorageAccount;
 * import com.pulumi.azurenative.storage.StorageAccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageAccount = new StorageAccount("storageAccount", StorageAccountArgs.builder()
 *             .accountName("sto4445")
 *             .allowBlobPublicAccess(false)
 *             .allowSharedKeyAccess(true)
 *             .defaultToOAuthAuthentication(false)
 *             .encryption(Map.ofEntries(
 *                 Map.entry("keySource", "Microsoft.Storage"),
 *                 Map.entry("requireInfrastructureEncryption", false),
 *                 Map.entry("services", Map.ofEntries(
 *                     Map.entry("blob", Map.ofEntries(
 *                         Map.entry("enabled", true),
 *                         Map.entry("keyType", "Account")
 *                     )),
 *                     Map.entry("file", Map.ofEntries(
 *                         Map.entry("enabled", true),
 *                         Map.entry("keyType", "Account")
 *                     ))
 *                 ))
 *             ))
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "losangeles001"),
 *                 Map.entry("type", "EdgeZone")
 *             ))
 *             .isHnsEnabled(true)
 *             .isSftpEnabled(true)
 *             .keyPolicy(Map.of("keyExpirationPeriodInDays", 20))
 *             .kind("Storage")
 *             .location("eastus")
 *             .minimumTlsVersion("TLS1_2")
 *             .resourceGroupName("res9101")
 *             .routingPreference(Map.ofEntries(
 *                 Map.entry("publishInternetEndpoints", true),
 *                 Map.entry("publishMicrosoftEndpoints", true),
 *                 Map.entry("routingChoice", "MicrosoftRouting")
 *             ))
 *             .sasPolicy(Map.ofEntries(
 *                 Map.entry("expirationAction", "Log"),
 *                 Map.entry("sasExpirationPeriod", "1.15:59:59")
 *             ))
 *             .sku(Map.of("name", "Standard_GRS"))
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "value1"),
 *                 Map.entry("key2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### StorageAccountCreateAllowedCopyScopeToAAD
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageAccount = new AzureNative.Storage.StorageAccount("storageAccount", new()
 *     {
 *         AccountName = "sto4445",
 *         AllowBlobPublicAccess = false,
 *         AllowSharedKeyAccess = true,
 *         AllowedCopyScope = "AAD",
 *         Encryption = new AzureNative.Storage.Inputs.EncryptionArgs
 *         {
 *             KeySource = "Microsoft.Storage",
 *             RequireInfrastructureEncryption = false,
 *             Services = new AzureNative.Storage.Inputs.EncryptionServicesArgs
 *             {
 *                 Blob = new AzureNative.Storage.Inputs.EncryptionServiceArgs
 *                 {
 *                     Enabled = true,
 *                     KeyType = "Account",
 *                 },
 *                 File = new AzureNative.Storage.Inputs.EncryptionServiceArgs
 *                 {
 *                     Enabled = true,
 *                     KeyType = "Account",
 *                 },
 *             },
 *         },
 *         IsHnsEnabled = true,
 *         KeyPolicy = new AzureNative.Storage.Inputs.KeyPolicyArgs
 *         {
 *             KeyExpirationPeriodInDays = 20,
 *         },
 *         Kind = "Storage",
 *         Location = "eastus",
 *         MinimumTlsVersion = "TLS1_2",
 *         ResourceGroupName = "res9101",
 *         RoutingPreference = new AzureNative.Storage.Inputs.RoutingPreferenceArgs
 *         {
 *             PublishInternetEndpoints = true,
 *             PublishMicrosoftEndpoints = true,
 *             RoutingChoice = "MicrosoftRouting",
 *         },
 *         SasPolicy = new AzureNative.Storage.Inputs.SasPolicyArgs
 *         {
 *             ExpirationAction = "Log",
 *             SasExpirationPeriod = "1.15:59:59",
 *         },
 *         Sku = new AzureNative.Storage.Inputs.SkuArgs
 *         {
 *             Name = "Standard_GRS",
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *             { "key2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := storage.NewStorageAccount(ctx, "storageAccount", &storage.StorageAccountArgs{
 * AccountName: pulumi.String("sto4445"),
 * AllowBlobPublicAccess: pulumi.Bool(false),
 * AllowSharedKeyAccess: pulumi.Bool(true),
 * AllowedCopyScope: pulumi.String("AAD"),
 * Encryption: storage.EncryptionResponse{
 * KeySource: pulumi.String("Microsoft.Storage"),
 * RequireInfrastructureEncryption: pulumi.Bool(false),
 * Services: interface{}{
 * Blob: &storage.EncryptionServiceArgs{
 * Enabled: pulumi.Bool(true),
 * KeyType: pulumi.String("Account"),
 * },
 * File: &storage.EncryptionServiceArgs{
 * Enabled: pulumi.Bool(true),
 * KeyType: pulumi.String("Account"),
 * },
 * },
 * },
 * IsHnsEnabled: pulumi.Bool(true),
 * KeyPolicy: &storage.KeyPolicyArgs{
 * KeyExpirationPeriodInDays: pulumi.Int(20),
 * },
 * Kind: pulumi.String("Storage"),
 * Location: pulumi.String("eastus"),
 * MinimumTlsVersion: pulumi.String("TLS1_2"),
 * ResourceGroupName: pulumi.String("res9101"),
 * RoutingPreference: &storage.RoutingPreferenceArgs{
 * PublishInternetEndpoints: pulumi.Bool(true),
 * PublishMicrosoftEndpoints: pulumi.Bool(true),
 * RoutingChoice: pulumi.String("MicrosoftRouting"),
 * },
 * SasPolicy: &storage.SasPolicyArgs{
 * ExpirationAction: pulumi.String("Log"),
 * SasExpirationPeriod: pulumi.String("1.15:59:59"),
 * },
 * Sku: &storage.SkuArgs{
 * Name: pulumi.String("Standard_GRS"),
 * },
 * Tags: pulumi.StringMap{
 * "key1": pulumi.String("value1"),
 * "key2": pulumi.String("value2"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.StorageAccount;
 * import com.pulumi.azurenative.storage.StorageAccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageAccount = new StorageAccount("storageAccount", StorageAccountArgs.builder()
 *             .accountName("sto4445")
 *             .allowBlobPublicAccess(false)
 *             .allowSharedKeyAccess(true)
 *             .allowedCopyScope("AAD")
 *             .encryption(Map.ofEntries(
 *                 Map.entry("keySource", "Microsoft.Storage"),
 *                 Map.entry("requireInfrastructureEncryption", false),
 *                 Map.entry("services", Map.ofEntries(
 *                     Map.entry("blob", Map.ofEntries(
 *                         Map.entry("enabled", true),
 *                         Map.entry("keyType", "Account")
 *                     )),
 *                     Map.entry("file", Map.ofEntries(
 *                         Map.entry("enabled", true),
 *                         Map.entry("keyType", "Account")
 *                     ))
 *                 ))
 *             ))
 *             .isHnsEnabled(true)
 *             .keyPolicy(Map.of("keyExpirationPeriodInDays", 20))
 *             .kind("Storage")
 *             .location("eastus")
 *             .minimumTlsVersion("TLS1_2")
 *             .resourceGroupName("res9101")
 *             .routingPreference(Map.ofEntries(
 *                 Map.entry("publishInternetEndpoints", true),
 *                 Map.entry("publishMicrosoftEndpoints", true),
 *                 Map.entry("routingChoice", "MicrosoftRouting")
 *             ))
 *             .sasPolicy(Map.ofEntries(
 *                 Map.entry("expirationAction", "Log"),
 *                 Map.entry("sasExpirationPeriod", "1.15:59:59")
 *             ))
 *             .sku(Map.of("name", "Standard_GRS"))
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "value1"),
 *                 Map.entry("key2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### StorageAccountCreateAllowedCopyScopeToPrivateLink
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageAccount = new AzureNative.Storage.StorageAccount("storageAccount", new()
 *     {
 *         AccountName = "sto4445",
 *         AllowBlobPublicAccess = false,
 *         AllowSharedKeyAccess = true,
 *         AllowedCopyScope = "PrivateLink",
 *         Encryption = new AzureNative.Storage.Inputs.EncryptionArgs
 *         {
 *             KeySource = "Microsoft.Storage",
 *             RequireInfrastructureEncryption = false,
 *             Services = new AzureNative.Storage.Inputs.EncryptionServicesArgs
 *             {
 *                 Blob = new AzureNative.Storage.Inputs.EncryptionServiceArgs
 *                 {
 *                     Enabled = true,
 *                     KeyType = "Account",
 *                 },
 *                 File = new AzureNative.Storage.Inputs.EncryptionServiceArgs
 *                 {
 *                     Enabled = true,
 *                     KeyType = "Account",
 *                 },
 *             },
 *         },
 *         IsHnsEnabled = true,
 *         KeyPolicy = new AzureNative.Storage.Inputs.KeyPolicyArgs
 *         {
 *             KeyExpirationPeriodInDays = 20,
 *         },
 *         Kind = "Storage",
 *         Location = "eastus",
 *         MinimumTlsVersion = "TLS1_2",
 *         ResourceGroupName = "res9101",
 *         RoutingPreference = new AzureNative.Storage.Inputs.RoutingPreferenceArgs
 *         {
 *             PublishInternetEndpoints = true,
 *             PublishMicrosoftEndpoints = true,
 *             RoutingChoice = "MicrosoftRouting",
 *         },
 *         SasPolicy = new AzureNative.Storage.Inputs.SasPolicyArgs
 *         {
 *             ExpirationAction = "Log",
 *             SasExpirationPeriod = "1.15:59:59",
 *         },
 *         Sku = new AzureNative.Storage.Inputs.SkuArgs
 *         {
 *             Name = "Standard_GRS",
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *             { "key2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := storage.NewStorageAccount(ctx, "storageAccount", &storage.StorageAccountArgs{
 * AccountName: pulumi.String("sto4445"),
 * AllowBlobPublicAccess: pulumi.Bool(false),
 * AllowSharedKeyAccess: pulumi.Bool(true),
 * AllowedCopyScope: pulumi.String("PrivateLink"),
 * Encryption: storage.EncryptionResponse{
 * KeySource: pulumi.String("Microsoft.Storage"),
 * RequireInfrastructureEncryption: pulumi.Bool(false),
 * Services: interface{}{
 * Blob: &storage.EncryptionServiceArgs{
 * Enabled: pulumi.Bool(true),
 * KeyType: pulumi.String("Account"),
 * },
 * File: &storage.EncryptionServiceArgs{
 * Enabled: pulumi.Bool(true),
 * KeyType: pulumi.String("Account"),
 * },
 * },
 * },
 * IsHnsEnabled: pulumi.Bool(true),
 * KeyPolicy: &storage.KeyPolicyArgs{
 * KeyExpirationPeriodInDays: pulumi.Int(20),
 * },
 * Kind: pulumi.String("Storage"),
 * Location: pulumi.String("eastus"),
 * MinimumTlsVersion: pulumi.String("TLS1_2"),
 * ResourceGroupName: pulumi.String("res9101"),
 * RoutingPreference: &storage.RoutingPreferenceArgs{
 * PublishInternetEndpoints: pulumi.Bool(true),
 * PublishMicrosoftEndpoints: pulumi.Bool(true),
 * RoutingChoice: pulumi.String("MicrosoftRouting"),
 * },
 * SasPolicy: &storage.SasPolicyArgs{
 * ExpirationAction: pulumi.String("Log"),
 * SasExpirationPeriod: pulumi.String("1.15:59:59"),
 * },
 * Sku: &storage.SkuArgs{
 * Name: pulumi.String("Standard_GRS"),
 * },
 * Tags: pulumi.StringMap{
 * "key1": pulumi.String("value1"),
 * "key2": pulumi.String("value2"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.StorageAccount;
 * import com.pulumi.azurenative.storage.StorageAccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageAccount = new StorageAccount("storageAccount", StorageAccountArgs.builder()
 *             .accountName("sto4445")
 *             .allowBlobPublicAccess(false)
 *             .allowSharedKeyAccess(true)
 *             .allowedCopyScope("PrivateLink")
 *             .encryption(Map.ofEntries(
 *                 Map.entry("keySource", "Microsoft.Storage"),
 *                 Map.entry("requireInfrastructureEncryption", false),
 *                 Map.entry("services", Map.ofEntries(
 *                     Map.entry("blob", Map.ofEntries(
 *                         Map.entry("enabled", true),
 *                         Map.entry("keyType", "Account")
 *                     )),
 *                     Map.entry("file", Map.ofEntries(
 *                         Map.entry("enabled", true),
 *                         Map.entry("keyType", "Account")
 *                     ))
 *                 ))
 *             ))
 *             .isHnsEnabled(true)
 *             .keyPolicy(Map.of("keyExpirationPeriodInDays", 20))
 *             .kind("Storage")
 *             .location("eastus")
 *             .minimumTlsVersion("TLS1_2")
 *             .resourceGroupName("res9101")
 *             .routingPreference(Map.ofEntries(
 *                 Map.entry("publishInternetEndpoints", true),
 *                 Map.entry("publishMicrosoftEndpoints", true),
 *                 Map.entry("routingChoice", "MicrosoftRouting")
 *             ))
 *             .sasPolicy(Map.ofEntries(
 *                 Map.entry("expirationAction", "Log"),
 *                 Map.entry("sasExpirationPeriod", "1.15:59:59")
 *             ))
 *             .sku(Map.of("name", "Standard_GRS"))
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "value1"),
 *                 Map.entry("key2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### StorageAccountCreateDisallowPublicNetworkAccess
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageAccount = new AzureNative.Storage.StorageAccount("storageAccount", new()
 *     {
 *         AccountName = "sto4445",
 *         AllowBlobPublicAccess = false,
 *         AllowSharedKeyAccess = true,
 *         Encryption = new AzureNative.Storage.Inputs.EncryptionArgs
 *         {
 *             KeySource = "Microsoft.Storage",
 *             RequireInfrastructureEncryption = false,
 *             Services = new AzureNative.Storage.Inputs.EncryptionServicesArgs
 *             {
 *                 Blob = new AzureNative.Storage.Inputs.EncryptionServiceArgs
 *                 {
 *                     Enabled = true,
 *                     KeyType = "Account",
 *                 },
 *                 File = new AzureNative.Storage.Inputs.EncryptionServiceArgs
 *                 {
 *                     Enabled = true,
 *                     KeyType = "Account",
 *                 },
 *             },
 *         },
 *         ExtendedLocation = new AzureNative.Storage.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "losangeles001",
 *             Type = "EdgeZone",
 *         },
 *         IsHnsEnabled = true,
 *         KeyPolicy = new AzureNative.Storage.Inputs.KeyPolicyArgs
 *         {
 *             KeyExpirationPeriodInDays = 20,
 *         },
 *         Kind = "Storage",
 *         Location = "eastus",
 *         MinimumTlsVersion = "TLS1_2",
 *         PublicNetworkAccess = "Disabled",
 *         ResourceGroupName = "res9101",
 *         RoutingPreference = new AzureNative.Storage.Inputs.RoutingPreferenceArgs
 *         {
 *             PublishInternetEndpoints = true,
 *             PublishMicrosoftEndpoints = true,
 *             RoutingChoice = "MicrosoftRouting",
 *         },
 *         SasPolicy = new AzureNative.Storage.Inputs.SasPolicyArgs
 *         {
 *             ExpirationAction = "Log",
 *             SasExpirationPeriod = "1.15:59:59",
 *         },
 *         Sku = new AzureNative.Storage.Inputs.SkuArgs
 *         {
 *             Name = "Standard_GRS",
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *             { "key2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := storage.NewStorageAccount(ctx, "storageAccount", &storage.StorageAccountArgs{
 * AccountName: pulumi.String("sto4445"),
 * AllowBlobPublicAccess: pulumi.Bool(false),
 * AllowSharedKeyAccess: pulumi.Bool(true),
 * Encryption: storage.EncryptionResponse{
 * KeySource: pulumi.String("Microsoft.Storage"),
 * RequireInfrastructureEncryption: pulumi.Bool(false),
 * Services: interface{}{
 * Blob: &storage.EncryptionServiceArgs{
 * Enabled: pulumi.Bool(true),
 * KeyType: pulumi.String("Account"),
 * },
 * File: &storage.EncryptionServiceArgs{
 * Enabled: pulumi.Bool(true),
 * KeyType: pulumi.String("Account"),
 * },
 * },
 * },
 * ExtendedLocation: &storage.ExtendedLocationArgs{
 * Name: pulumi.String("losangeles001"),
 * Type: pulumi.String("EdgeZone"),
 * },
 * IsHnsEnabled: pulumi.Bool(true),
 * KeyPolicy: &storage.KeyPolicyArgs{
 * KeyExpirationPeriodInDays: pulumi.Int(20),
 * },
 * Kind: pulumi.String("Storage"),
 * Location: pulumi.String("eastus"),
 * MinimumTlsVersion: pulumi.String("TLS1_2"),
 * PublicNetworkAccess: pulumi.String("Disabled"),
 * ResourceGroupName: pulumi.String("res9101"),
 * RoutingPreference: &storage.RoutingPreferenceArgs{
 * PublishInternetEndpoints: pulumi.Bool(true),
 * PublishMicrosoftEndpoints: pulumi.Bool(true),
 * RoutingChoice: pulumi.String("MicrosoftRouting"),
 * },
 * SasPolicy: &storage.SasPolicyArgs{
 * ExpirationAction: pulumi.String("Log"),
 * SasExpirationPeriod: pulumi.String("1.15:59:59"),
 * },
 * Sku: &storage.SkuArgs{
 * Name: pulumi.String("Standard_GRS"),
 * },
 * Tags: pulumi.StringMap{
 * "key1": pulumi.String("value1"),
 * "key2": pulumi.String("value2"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.StorageAccount;
 * import com.pulumi.azurenative.storage.StorageAccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageAccount = new StorageAccount("storageAccount", StorageAccountArgs.builder()
 *             .accountName("sto4445")
 *             .allowBlobPublicAccess(false)
 *             .allowSharedKeyAccess(true)
 *             .encryption(Map.ofEntries(
 *                 Map.entry("keySource", "Microsoft.Storage"),
 *                 Map.entry("requireInfrastructureEncryption", false),
 *                 Map.entry("services", Map.ofEntries(
 *                     Map.entry("blob", Map.ofEntries(
 *                         Map.entry("enabled", true),
 *                         Map.entry("keyType", "Account")
 *                     )),
 *                     Map.entry("file", Map.ofEntries(
 *                         Map.entry("enabled", true),
 *                         Map.entry("keyType", "Account")
 *                     ))
 *                 ))
 *             ))
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "losangeles001"),
 *                 Map.entry("type", "EdgeZone")
 *             ))
 *             .isHnsEnabled(true)
 *             .keyPolicy(Map.of("keyExpirationPeriodInDays", 20))
 *             .kind("Storage")
 *             .location("eastus")
 *             .minimumTlsVersion("TLS1_2")
 *             .publicNetworkAccess("Disabled")
 *             .resourceGroupName("res9101")
 *             .routingPreference(Map.ofEntries(
 *                 Map.entry("publishInternetEndpoints", true),
 *                 Map.entry("publishMicrosoftEndpoints", true),
 *                 Map.entry("routingChoice", "MicrosoftRouting")
 *             ))
 *             .sasPolicy(Map.ofEntries(
 *                 Map.entry("expirationAction", "Log"),
 *                 Map.entry("sasExpirationPeriod", "1.15:59:59")
 *             ))
 *             .sku(Map.of("name", "Standard_GRS"))
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "value1"),
 *                 Map.entry("key2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### StorageAccountCreateDnsEndpointTypeToAzureDnsZone
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageAccount = new AzureNative.Storage.StorageAccount("storageAccount", new()
 *     {
 *         AccountName = "sto4445",
 *         AllowBlobPublicAccess = false,
 *         AllowSharedKeyAccess = true,
 *         DefaultToOAuthAuthentication = false,
 *         DnsEndpointType = "AzureDnsZone",
 *         Encryption = new AzureNative.Storage.Inputs.EncryptionArgs
 *         {
 *             KeySource = "Microsoft.Storage",
 *             RequireInfrastructureEncryption = false,
 *             Services = new AzureNative.Storage.Inputs.EncryptionServicesArgs
 *             {
 *                 Blob = new AzureNative.Storage.Inputs.EncryptionServiceArgs
 *                 {
 *                     Enabled = true,
 *                     KeyType = "Account",
 *                 },
 *                 File = new AzureNative.Storage.Inputs.EncryptionServiceArgs
 *                 {
 *                     Enabled = true,
 *                     KeyType = "Account",
 *                 },
 *             },
 *         },
 *         ExtendedLocation = new AzureNative.Storage.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "losangeles001",
 *             Type = "EdgeZone",
 *         },
 *         IsHnsEnabled = true,
 *         IsSftpEnabled = true,
 *         KeyPolicy = new AzureNative.Storage.Inputs.KeyPolicyArgs
 *         {
 *             KeyExpirationPeriodInDays = 20,
 *         },
 *         Kind = "Storage",
 *         Location = "eastus",
 *         MinimumTlsVersion = "TLS1_2",
 *         ResourceGroupName = "res9101",
 *         RoutingPreference = new AzureNative.Storage.Inputs.RoutingPreferenceArgs
 *         {
 *             PublishInternetEndpoints = true,
 *             PublishMicrosoftEndpoints = true,
 *             RoutingChoice = "MicrosoftRouting",
 *         },
 *         SasPolicy = new AzureNative.Storage.Inputs.SasPolicyArgs
 *         {
 *             ExpirationAction = "Log",
 *             SasExpirationPeriod = "1.15:59:59",
 *         },
 *         Sku = new AzureNative.Storage.Inputs.SkuArgs
 *         {
 *             Name = "Standard_GRS",
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *             { "key2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := storage.NewStorageAccount(ctx, "storageAccount", &storage.StorageAccountArgs{
 * AccountName: pulumi.String("sto4445"),
 * AllowBlobPublicAccess: pulumi.Bool(false),
 * AllowSharedKeyAccess: pulumi.Bool(true),
 * DefaultToOAuthAuthentication: pulumi.Bool(false),
 * DnsEndpointType: pulumi.String("AzureDnsZone"),
 * Encryption: storage.EncryptionResponse{
 * KeySource: pulumi.String("Microsoft.Storage"),
 * RequireInfrastructureEncryption: pulumi.Bool(false),
 * Services: interface{}{
 * Blob: &storage.EncryptionServiceArgs{
 * Enabled: pulumi.Bool(true),
 * KeyType: pulumi.String("Account"),
 * },
 * File: &storage.EncryptionServiceArgs{
 * Enabled: pulumi.Bool(true),
 * KeyType: pulumi.String("Account"),
 * },
 * },
 * },
 * ExtendedLocation: &storage.ExtendedLocationArgs{
 * Name: pulumi.String("losangeles001"),
 * Type: pulumi.String("EdgeZone"),
 * },
 * IsHnsEnabled: pulumi.Bool(true),
 * IsSftpEnabled: pulumi.Bool(true),
 * KeyPolicy: &storage.KeyPolicyArgs{
 * KeyExpirationPeriodInDays: pulumi.Int(20),
 * },
 * Kind: pulumi.String("Storage"),
 * Location: pulumi.String("eastus"),
 * MinimumTlsVersion: pulumi.String("TLS1_2"),
 * ResourceGroupName: pulumi.String("res9101"),
 * RoutingPreference: &storage.RoutingPreferenceArgs{
 * PublishInternetEndpoints: pulumi.Bool(true),
 * PublishMicrosoftEndpoints: pulumi.Bool(true),
 * RoutingChoice: pulumi.String("MicrosoftRouting"),
 * },
 * SasPolicy: &storage.SasPolicyArgs{
 * ExpirationAction: pulumi.String("Log"),
 * SasExpirationPeriod: pulumi.String("1.15:59:59"),
 * },
 * Sku: &storage.SkuArgs{
 * Name: pulumi.String("Standard_GRS"),
 * },
 * Tags: pulumi.StringMap{
 * "key1": pulumi.String("value1"),
 * "key2": pulumi.String("value2"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.StorageAccount;
 * import com.pulumi.azurenative.storage.StorageAccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageAccount = new StorageAccount("storageAccount", StorageAccountArgs.builder()
 *             .accountName("sto4445")
 *             .allowBlobPublicAccess(false)
 *             .allowSharedKeyAccess(true)
 *             .defaultToOAuthAuthentication(false)
 *             .dnsEndpointType("AzureDnsZone")
 *             .encryption(Map.ofEntries(
 *                 Map.entry("keySource", "Microsoft.Storage"),
 *                 Map.entry("requireInfrastructureEncryption", false),
 *                 Map.entry("services", Map.ofEntries(
 *                     Map.entry("blob", Map.ofEntries(
 *                         Map.entry("enabled", true),
 *                         Map.entry("keyType", "Account")
 *                     )),
 *                     Map.entry("file", Map.ofEntries(
 *                         Map.entry("enabled", true),
 *                         Map.entry("keyType", "Account")
 *                     ))
 *                 ))
 *             ))
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "losangeles001"),
 *                 Map.entry("type", "EdgeZone")
 *             ))
 *             .isHnsEnabled(true)
 *             .isSftpEnabled(true)
 *             .keyPolicy(Map.of("keyExpirationPeriodInDays", 20))
 *             .kind("Storage")
 *             .location("eastus")
 *             .minimumTlsVersion("TLS1_2")
 *             .resourceGroupName("res9101")
 *             .routingPreference(Map.ofEntries(
 *                 Map.entry("publishInternetEndpoints", true),
 *                 Map.entry("publishMicrosoftEndpoints", true),
 *                 Map.entry("routingChoice", "MicrosoftRouting")
 *             ))
 *             .sasPolicy(Map.ofEntries(
 *                 Map.entry("expirationAction", "Log"),
 *                 Map.entry("sasExpirationPeriod", "1.15:59:59")
 *             ))
 *             .sku(Map.of("name", "Standard_GRS"))
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "value1"),
 *                 Map.entry("key2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### StorageAccountCreateDnsEndpointTypeToStandard
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageAccount = new AzureNative.Storage.StorageAccount("storageAccount", new()
 *     {
 *         AccountName = "sto4445",
 *         AllowBlobPublicAccess = false,
 *         AllowSharedKeyAccess = true,
 *         DefaultToOAuthAuthentication = false,
 *         DnsEndpointType = "Standard",
 *         Encryption = new AzureNative.Storage.Inputs.EncryptionArgs
 *         {
 *             KeySource = "Microsoft.Storage",
 *             RequireInfrastructureEncryption = false,
 *             Services = new AzureNative.Storage.Inputs.EncryptionServicesArgs
 *             {
 *                 Blob = new AzureNative.Storage.Inputs.EncryptionServiceArgs
 *                 {
 *                     Enabled = true,
 *                     KeyType = "Account",
 *                 },
 *                 File = new AzureNative.Storage.Inputs.EncryptionServiceArgs
 *                 {
 *                     Enabled = true,
 *                     KeyType = "Account",
 *                 },
 *             },
 *         },
 *         ExtendedLocation = new AzureNative.Storage.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "losangeles001",
 *             Type = "EdgeZone",
 *         },
 *         IsHnsEnabled = true,
 *         IsSftpEnabled = true,
 *         KeyPolicy = new AzureNative.Storage.Inputs.KeyPolicyArgs
 *         {
 *             KeyExpirationPeriodInDays = 20,
 *         },
 *         Kind = "Storage",
 *         Location = "eastus",
 *         MinimumTlsVersion = "TLS1_2",
 *         ResourceGroupName = "res9101",
 *         RoutingPreference = new AzureNative.Storage.Inputs.RoutingPreferenceArgs
 *         {
 *             PublishInternetEndpoints = true,
 *             PublishMicrosoftEndpoints = true,
 *             RoutingChoice = "MicrosoftRouting",
 *         },
 *         SasPolicy = new AzureNative.Storage.Inputs.SasPolicyArgs
 *         {
 *             ExpirationAction = "Log",
 *             SasExpirationPeriod = "1.15:59:59",
 *         },
 *         Sku = new AzureNative.Storage.Inputs.SkuArgs
 *         {
 *             Name = "Standard_GRS",
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *             { "key2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := storage.NewStorageAccount(ctx, "storageAccount", &storage.StorageAccountArgs{
 * AccountName: pulumi.String("sto4445"),
 * AllowBlobPublicAccess: pulumi.Bool(false),
 * AllowSharedKeyAccess: pulumi.Bool(true),
 * DefaultToOAuthAuthentication: pulumi.Bool(false),
 * DnsEndpointType: pulumi.String("Standard"),
 * Encryption: storage.EncryptionResponse{
 * KeySource: pulumi.String("Microsoft.Storage"),
 * RequireInfrastructureEncryption: pulumi.Bool(false),
 * Services: interface{}{
 * Blob: &storage.EncryptionServiceArgs{
 * Enabled: pulumi.Bool(true),
 * KeyType: pulumi.String("Account"),
 * },
 * File: &storage.EncryptionServiceArgs{
 * Enabled: pulumi.Bool(true),
 * KeyType: pulumi.String("Account"),
 * },
 * },
 * },
 * ExtendedLocation: &storage.ExtendedLocationArgs{
 * Name: pulumi.String("losangeles001"),
 * Type: pulumi.String("EdgeZone"),
 * },
 * IsHnsEnabled: pulumi.Bool(true),
 * IsSftpEnabled: pulumi.Bool(true),
 * KeyPolicy: &storage.KeyPolicyArgs{
 * KeyExpirationPeriodInDays: pulumi.Int(20),
 * },
 * Kind: pulumi.String("Storage"),
 * Location: pulumi.String("eastus"),
 * MinimumTlsVersion: pulumi.String("TLS1_2"),
 * ResourceGroupName: pulumi.String("res9101"),
 * RoutingPreference: &storage.RoutingPreferenceArgs{
 * PublishInternetEndpoints: pulumi.Bool(true),
 * PublishMicrosoftEndpoints: pulumi.Bool(true),
 * RoutingChoice: pulumi.String("MicrosoftRouting"),
 * },
 * SasPolicy: &storage.SasPolicyArgs{
 * ExpirationAction: pulumi.String("Log"),
 * SasExpirationPeriod: pulumi.String("1.15:59:59"),
 * },
 * Sku: &storage.SkuArgs{
 * Name: pulumi.String("Standard_GRS"),
 * },
 * Tags: pulumi.StringMap{
 * "key1": pulumi.String("value1"),
 * "key2": pulumi.String("value2"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.StorageAccount;
 * import com.pulumi.azurenative.storage.StorageAccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageAccount = new StorageAccount("storageAccount", StorageAccountArgs.builder()
 *             .accountName("sto4445")
 *             .allowBlobPublicAccess(false)
 *             .allowSharedKeyAccess(true)
 *             .defaultToOAuthAuthentication(false)
 *             .dnsEndpointType("Standard")
 *             .encryption(Map.ofEntries(
 *                 Map.entry("keySource", "Microsoft.Storage"),
 *                 Map.entry("requireInfrastructureEncryption", false),
 *                 Map.entry("services", Map.ofEntries(
 *                     Map.entry("blob", Map.ofEntries(
 *                         Map.entry("enabled", true),
 *                         Map.entry("keyType", "Account")
 *                     )),
 *                     Map.entry("file", Map.ofEntries(
 *                         Map.entry("enabled", true),
 *                         Map.entry("keyType", "Account")
 *                     ))
 *                 ))
 *             ))
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "losangeles001"),
 *                 Map.entry("type", "EdgeZone")
 *             ))
 *             .isHnsEnabled(true)
 *             .isSftpEnabled(true)
 *             .keyPolicy(Map.of("keyExpirationPeriodInDays", 20))
 *             .kind("Storage")
 *             .location("eastus")
 *             .minimumTlsVersion("TLS1_2")
 *             .resourceGroupName("res9101")
 *             .routingPreference(Map.ofEntries(
 *                 Map.entry("publishInternetEndpoints", true),
 *                 Map.entry("publishMicrosoftEndpoints", true),
 *                 Map.entry("routingChoice", "MicrosoftRouting")
 *             ))
 *             .sasPolicy(Map.ofEntries(
 *                 Map.entry("expirationAction", "Log"),
 *                 Map.entry("sasExpirationPeriod", "1.15:59:59")
 *             ))
 *             .sku(Map.of("name", "Standard_GRS"))
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "value1"),
 *                 Map.entry("key2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### StorageAccountCreateEnablePublicNetworkAccess
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageAccount = new AzureNative.Storage.StorageAccount("storageAccount", new()
 *     {
 *         AccountName = "sto4445",
 *         AllowBlobPublicAccess = false,
 *         AllowSharedKeyAccess = true,
 *         Encryption = new AzureNative.Storage.Inputs.EncryptionArgs
 *         {
 *             KeySource = "Microsoft.Storage",
 *             RequireInfrastructureEncryption = false,
 *             Services = new AzureNative.Storage.Inputs.EncryptionServicesArgs
 *             {
 *                 Blob = new AzureNative.Storage.Inputs.EncryptionServiceArgs
 *                 {
 *                     Enabled = true,
 *                     KeyType = "Account",
 *                 },
 *                 File = new AzureNative.Storage.Inputs.EncryptionServiceArgs
 *                 {
 *                     Enabled = true,
 *                     KeyType = "Account",
 *                 },
 *             },
 *         },
 *         ExtendedLocation = new AzureNative.Storage.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "losangeles001",
 *             Type = "EdgeZone",
 *         },
 *         IsHnsEnabled = true,
 *         KeyPolicy = new AzureNative.Storage.Inputs.KeyPolicyArgs
 *         {
 *             KeyExpirationPeriodInDays = 20,
 *         },
 *         Kind = "Storage",
 *         Location = "eastus",
 *         MinimumTlsVersion = "TLS1_2",
 *         PublicNetworkAccess = "Enabled",
 *         ResourceGroupName = "res9101",
 *         RoutingPreference = new AzureNative.Storage.Inputs.RoutingPreferenceArgs
 *         {
 *             PublishInternetEndpoints = true,
 *             PublishMicrosoftEndpoints = true,
 *             RoutingChoice = "MicrosoftRouting",
 *         },
 *         SasPolicy = new AzureNative.Storage.Inputs.SasPolicyArgs
 *         {
 *             ExpirationAction = "Log",
 *             SasExpirationPeriod = "1.15:59:59",
 *         },
 *         Sku = new AzureNative.Storage.Inputs.SkuArgs
 *         {
 *             Name = "Standard_GRS",
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *             { "key2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := storage.NewStorageAccount(ctx, "storageAccount", &storage.StorageAccountArgs{
 * AccountName: pulumi.String("sto4445"),
 * AllowBlobPublicAccess: pulumi.Bool(false),
 * AllowSharedKeyAccess: pulumi.Bool(true),
 * Encryption: storage.EncryptionResponse{
 * KeySource: pulumi.String("Microsoft.Storage"),
 * RequireInfrastructureEncryption: pulumi.Bool(false),
 * Services: interface{}{
 * Blob: &storage.EncryptionServiceArgs{
 * Enabled: pulumi.Bool(true),
 * KeyType: pulumi.String("Account"),
 * },
 * File: &storage.EncryptionServiceArgs{
 * Enabled: pulumi.Bool(true),
 * KeyType: pulumi.String("Account"),
 * },
 * },
 * },
 * ExtendedLocation: &storage.ExtendedLocationArgs{
 * Name: pulumi.String("losangeles001"),
 * Type: pulumi.String("EdgeZone"),
 * },
 * IsHnsEnabled: pulumi.Bool(true),
 * KeyPolicy: &storage.KeyPolicyArgs{
 * KeyExpirationPeriodInDays: pulumi.Int(20),
 * },
 * Kind: pulumi.String("Storage"),
 * Location: pulumi.String("eastus"),
 * MinimumTlsVersion: pulumi.String("TLS1_2"),
 * PublicNetworkAccess: pulumi.String("Enabled"),
 * ResourceGroupName: pulumi.String("res9101"),
 * RoutingPreference: &storage.RoutingPreferenceArgs{
 * PublishInternetEndpoints: pulumi.Bool(true),
 * PublishMicrosoftEndpoints: pulumi.Bool(true),
 * RoutingChoice: pulumi.String("MicrosoftRouting"),
 * },
 * SasPolicy: &storage.SasPolicyArgs{
 * ExpirationAction: pulumi.String("Log"),
 * SasExpirationPeriod: pulumi.String("1.15:59:59"),
 * },
 * Sku: &storage.SkuArgs{
 * Name: pulumi.String("Standard_GRS"),
 * },
 * Tags: pulumi.StringMap{
 * "key1": pulumi.String("value1"),
 * "key2": pulumi.String("value2"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.StorageAccount;
 * import com.pulumi.azurenative.storage.StorageAccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageAccount = new StorageAccount("storageAccount", StorageAccountArgs.builder()
 *             .accountName("sto4445")
 *             .allowBlobPublicAccess(false)
 *             .allowSharedKeyAccess(true)
 *             .encryption(Map.ofEntries(
 *                 Map.entry("keySource", "Microsoft.Storage"),
 *                 Map.entry("requireInfrastructureEncryption", false),
 *                 Map.entry("services", Map.ofEntries(
 *                     Map.entry("blob", Map.ofEntries(
 *                         Map.entry("enabled", true),
 *                         Map.entry("keyType", "Account")
 *                     )),
 *                     Map.entry("file", Map.ofEntries(
 *                         Map.entry("enabled", true),
 *                         Map.entry("keyType", "Account")
 *                     ))
 *                 ))
 *             ))
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "losangeles001"),
 *                 Map.entry("type", "EdgeZone")
 *             ))
 *             .isHnsEnabled(true)
 *             .keyPolicy(Map.of("keyExpirationPeriodInDays", 20))
 *             .kind("Storage")
 *             .location("eastus")
 *             .minimumTlsVersion("TLS1_2")
 *             .publicNetworkAccess("Enabled")
 *             .resourceGroupName("res9101")
 *             .routingPreference(Map.ofEntries(
 *                 Map.entry("publishInternetEndpoints", true),
 *                 Map.entry("publishMicrosoftEndpoints", true),
 *                 Map.entry("routingChoice", "MicrosoftRouting")
 *             ))
 *             .sasPolicy(Map.ofEntries(
 *                 Map.entry("expirationAction", "Log"),
 *                 Map.entry("sasExpirationPeriod", "1.15:59:59")
 *             ))
 *             .sku(Map.of("name", "Standard_GRS"))
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "value1"),
 *                 Map.entry("key2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### StorageAccountCreatePremiumBlockBlobStorage
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageAccount = new AzureNative.Storage.StorageAccount("storageAccount", new()
 *     {
 *         AccountName = "sto4445",
 *         AllowSharedKeyAccess = true,
 *         Encryption = new AzureNative.Storage.Inputs.EncryptionArgs
 *         {
 *             KeySource = "Microsoft.Storage",
 *             RequireInfrastructureEncryption = false,
 *             Services = new AzureNative.Storage.Inputs.EncryptionServicesArgs
 *             {
 *                 Blob = new AzureNative.Storage.Inputs.EncryptionServiceArgs
 *                 {
 *                     Enabled = true,
 *                     KeyType = "Account",
 *                 },
 *                 File = new AzureNative.Storage.Inputs.EncryptionServiceArgs
 *                 {
 *                     Enabled = true,
 *                     KeyType = "Account",
 *                 },
 *             },
 *         },
 *         Kind = "BlockBlobStorage",
 *         Location = "eastus",
 *         MinimumTlsVersion = "TLS1_2",
 *         ResourceGroupName = "res9101",
 *         Sku = new AzureNative.Storage.Inputs.SkuArgs
 *         {
 *             Name = "Premium_LRS",
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *             { "key2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := storage.NewStorageAccount(ctx, "storageAccount", &storage.StorageAccountArgs{
 * AccountName: pulumi.String("sto4445"),
 * AllowSharedKeyAccess: pulumi.Bool(true),
 * Encryption: storage.EncryptionResponse{
 * KeySource: pulumi.String("Microsoft.Storage"),
 * RequireInfrastructureEncryption: pulumi.Bool(false),
 * Services: interface{}{
 * Blob: &storage.EncryptionServiceArgs{
 * Enabled: pulumi.Bool(true),
 * KeyType: pulumi.String("Account"),
 * },
 * File: &storage.EncryptionServiceArgs{
 * Enabled: pulumi.Bool(true),
 * KeyType: pulumi.String("Account"),
 * },
 * },
 * },
 * Kind: pulumi.String("BlockBlobStorage"),
 * Location: pulumi.String("eastus"),
 * MinimumTlsVersion: pulumi.String("TLS1_2"),
 * ResourceGroupName: pulumi.String("res9101"),
 * Sku: &storage.SkuArgs{
 * Name: pulumi.String("Premium_LRS"),
 * },
 * Tags: pulumi.StringMap{
 * "key1": pulumi.String("value1"),
 * "key2": pulumi.String("value2"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.StorageAccount;
 * import com.pulumi.azurenative.storage.StorageAccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageAccount = new StorageAccount("storageAccount", StorageAccountArgs.builder()
 *             .accountName("sto4445")
 *             .allowSharedKeyAccess(true)
 *             .encryption(Map.ofEntries(
 *                 Map.entry("keySource", "Microsoft.Storage"),
 *                 Map.entry("requireInfrastructureEncryption", false),
 *                 Map.entry("services", Map.ofEntries(
 *                     Map.entry("blob", Map.ofEntries(
 *                         Map.entry("enabled", true),
 *                         Map.entry("keyType", "Account")
 *                     )),
 *                     Map.entry("file", Map.ofEntries(
 *                         Map.entry("enabled", true),
 *                         Map.entry("keyType", "Account")
 *                     ))
 *                 ))
 *             ))
 *             .kind("BlockBlobStorage")
 *             .location("eastus")
 *             .minimumTlsVersion("TLS1_2")
 *             .resourceGroupName("res9101")
 *             .sku(Map.of("name", "Premium_LRS"))
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "value1"),
 *                 Map.entry("key2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### StorageAccountCreateWithImmutabilityPolicy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageAccount = new AzureNative.Storage.StorageAccount("storageAccount", new()
 *     {
 *         AccountName = "sto4445",
 *         ExtendedLocation = new AzureNative.Storage.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "losangeles001",
 *             Type = "EdgeZone",
 *         },
 *         ImmutableStorageWithVersioning = new AzureNative.Storage.Inputs.ImmutableStorageAccountArgs
 *         {
 *             Enabled = true,
 *             ImmutabilityPolicy = new AzureNative.Storage.Inputs.AccountImmutabilityPolicyPropertiesArgs
 *             {
 *                 AllowProtectedAppendWrites = true,
 *                 ImmutabilityPeriodSinceCreationInDays = 15,
 *                 State = "Unlocked",
 *             },
 *         },
 *         Kind = "Storage",
 *         Location = "eastus",
 *         ResourceGroupName = "res9101",
 *         Sku = new AzureNative.Storage.Inputs.SkuArgs
 *         {
 *             Name = "Standard_GRS",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewStorageAccount(ctx, "storageAccount", &storage.StorageAccountArgs{
 * 			AccountName: pulumi.String("sto4445"),
 * 			ExtendedLocation: &storage.ExtendedLocationArgs{
 * 				Name: pulumi.String("losangeles001"),
 * 				Type: pulumi.String("EdgeZone"),
 * 			},
 * 			ImmutableStorageWithVersioning: storage.ImmutableStorageAccountResponse{
 * 				Enabled: pulumi.Bool(true),
 * 				ImmutabilityPolicy: &storage.AccountImmutabilityPolicyPropertiesArgs{
 * 					AllowProtectedAppendWrites:            pulumi.Bool(true),
 * 					ImmutabilityPeriodSinceCreationInDays: pulumi.Int(15),
 * 					State:                                 pulumi.String("Unlocked"),
 * 				},
 * 			},
 * 			Kind:              pulumi.String("Storage"),
 * 			Location:          pulumi.String("eastus"),
 * 			ResourceGroupName: pulumi.String("res9101"),
 * 			Sku: &storage.SkuArgs{
 * 				Name: pulumi.String("Standard_GRS"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.StorageAccount;
 * import com.pulumi.azurenative.storage.StorageAccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageAccount = new StorageAccount("storageAccount", StorageAccountArgs.builder()
 *             .accountName("sto4445")
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "losangeles001"),
 *                 Map.entry("type", "EdgeZone")
 *             ))
 *             .immutableStorageWithVersioning(Map.ofEntries(
 *                 Map.entry("enabled", true),
 *                 Map.entry("immutabilityPolicy", Map.ofEntries(
 *                     Map.entry("allowProtectedAppendWrites", true),
 *                     Map.entry("immutabilityPeriodSinceCreationInDays", 15),
 *                     Map.entry("state", "Unlocked")
 *                 ))
 *             ))
 *             .kind("Storage")
 *             .location("eastus")
 *             .resourceGroupName("res9101")
 *             .sku(Map.of("name", "Standard_GRS"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storage:StorageAccount sto4445 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}
 * ```
 * @property accessTier Required for storage accounts where kind = BlobStorage. The access tier is used for billing. The 'Premium' access tier is the default value for premium block blobs storage account type and it cannot be changed for the premium block blobs storage account type.
 * @property accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
 * @property allowBlobPublicAccess Allow or disallow public access to all blobs or containers in the storage account. The default interpretation is true for this property.
 * @property allowCrossTenantReplication Allow or disallow cross AAD tenant object replication. The default interpretation is true for this property.
 * @property allowSharedKeyAccess Indicates whether the storage account permits requests to be authorized with the account access key via Shared Key. If false, then all requests, including shared access signatures, must be authorized with Azure Active Directory (Azure AD). The default value is null, which is equivalent to true.
 * @property allowedCopyScope Restrict copy to and from Storage Accounts within an AAD tenant or with Private Links to the same VNet.
 * @property azureFilesIdentityBasedAuthentication Provides the identity based authentication settings for Azure Files.
 * @property customDomain User domain assigned to the storage account. Name is the CNAME source. Only one custom domain is supported per storage account at this time. To clear the existing custom domain, use an empty string for the custom domain name property.
 * @property defaultToOAuthAuthentication A boolean flag which indicates whether the default authentication is OAuth or not. The default interpretation is false for this property.
 * @property dnsEndpointType Allows you to specify the type of endpoint. Set this to AzureDNSZone to create a large number of accounts in a single subscription, which creates accounts in an Azure DNS Zone and the endpoint URL will have an alphanumeric DNS Zone identifier.
 * @property enableHttpsTrafficOnly Allows https traffic only to storage service if sets to true. The default value is true since API version 2019-04-01.
 * @property enableNfsV3 NFS 3.0 protocol support enabled if set to true.
 * @property encryption Encryption settings to be used for server-side encryption for the storage account.
 * @property extendedLocation Optional. Set the extended location of the resource. If not set, the storage account will be created in Azure main region. Otherwise it will be created in the specified extended location
 * @property identity The identity of the resource.
 * @property immutableStorageWithVersioning The property is immutable and can only be set to true at the account creation time. When set to true, it enables object level immutability for all the new containers in the account by default.
 * @property isHnsEnabled Account HierarchicalNamespace enabled if sets to true.
 * @property isLocalUserEnabled Enables local users feature, if set to true
 * @property isSftpEnabled Enables Secure File Transfer Protocol, if set to true
 * @property keyPolicy KeyPolicy assigned to the storage account.
 * @property kind Required. Indicates the type of storage account.
 * @property largeFileSharesState Allow large file shares if sets to Enabled. It cannot be disabled once it is enabled.
 * @property location Required. Gets or sets the location of the resource. This will be one of the supported and registered Azure Geo Regions (e.g. West US, East US, Southeast Asia, etc.). The geo region of a resource cannot be changed once it is created, but if an identical geo region is specified on update, the request will succeed.
 * @property minimumTlsVersion Set the minimum TLS version to be permitted on requests to storage. The default interpretation is TLS 1.0 for this property.
 * @property networkRuleSet Network rule set
 * @property publicNetworkAccess Allow or disallow public network access to Storage Account. Value is optional but if passed in, must be 'Enabled' or 'Disabled'.
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 * @property routingPreference Maintains information about the network routing choice opted by the user for data transfer
 * @property sasPolicy SasPolicy assigned to the storage account.
 * @property sku Required. Gets or sets the SKU name.
 * @property tags Gets or sets a list of key value pairs that describe the resource. These tags can be used for viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key with a length no greater than 128 characters and a value with a length no greater than 256 characters.
 */
public data class StorageAccountArgs(
    public val accessTier: Output<AccessTier>? = null,
    public val accountName: Output<String>? = null,
    public val allowBlobPublicAccess: Output<Boolean>? = null,
    public val allowCrossTenantReplication: Output<Boolean>? = null,
    public val allowSharedKeyAccess: Output<Boolean>? = null,
    public val allowedCopyScope: Output<Either<String, AllowedCopyScope>>? = null,
    public val azureFilesIdentityBasedAuthentication:
    Output<AzureFilesIdentityBasedAuthenticationArgs>? = null,
    public val customDomain: Output<CustomDomainArgs>? = null,
    public val defaultToOAuthAuthentication: Output<Boolean>? = null,
    public val dnsEndpointType: Output<Either<String, DnsEndpointType>>? = null,
    public val enableHttpsTrafficOnly: Output<Boolean>? = null,
    public val enableNfsV3: Output<Boolean>? = null,
    public val encryption: Output<EncryptionArgs>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val identity: Output<IdentityArgs>? = null,
    public val immutableStorageWithVersioning: Output<ImmutableStorageAccountArgs>? = null,
    public val isHnsEnabled: Output<Boolean>? = null,
    public val isLocalUserEnabled: Output<Boolean>? = null,
    public val isSftpEnabled: Output<Boolean>? = null,
    public val keyPolicy: Output<KeyPolicyArgs>? = null,
    public val kind: Output<Either<String, Kind>>? = null,
    public val largeFileSharesState: Output<Either<String, LargeFileSharesState>>? = null,
    public val location: Output<String>? = null,
    public val minimumTlsVersion: Output<Either<String, MinimumTlsVersion>>? = null,
    public val networkRuleSet: Output<NetworkRuleSetArgs>? = null,
    public val publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val routingPreference: Output<RoutingPreferenceArgs>? = null,
    public val sasPolicy: Output<SasPolicyArgs>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.StorageAccountArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.StorageAccountArgs =
        com.pulumi.azurenative.storage.StorageAccountArgs.builder()
            .accessTier(accessTier?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .allowBlobPublicAccess(allowBlobPublicAccess?.applyValue({ args0 -> args0 }))
            .allowCrossTenantReplication(allowCrossTenantReplication?.applyValue({ args0 -> args0 }))
            .allowSharedKeyAccess(allowSharedKeyAccess?.applyValue({ args0 -> args0 }))
            .allowedCopyScope(
                allowedCopyScope?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .azureFilesIdentityBasedAuthentication(
                azureFilesIdentityBasedAuthentication?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .customDomain(customDomain?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .defaultToOAuthAuthentication(defaultToOAuthAuthentication?.applyValue({ args0 -> args0 }))
            .dnsEndpointType(
                dnsEndpointType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .enableHttpsTrafficOnly(enableHttpsTrafficOnly?.applyValue({ args0 -> args0 }))
            .enableNfsV3(enableNfsV3?.applyValue({ args0 -> args0 }))
            .encryption(encryption?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .immutableStorageWithVersioning(
                immutableStorageWithVersioning?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .isHnsEnabled(isHnsEnabled?.applyValue({ args0 -> args0 }))
            .isLocalUserEnabled(isLocalUserEnabled?.applyValue({ args0 -> args0 }))
            .isSftpEnabled(isSftpEnabled?.applyValue({ args0 -> args0 }))
            .keyPolicy(keyPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kind(
                kind?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .largeFileSharesState(
                largeFileSharesState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .minimumTlsVersion(
                minimumTlsVersion?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .networkRuleSet(networkRuleSet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .publicNetworkAccess(
                publicNetworkAccess?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .routingPreference(routingPreference?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sasPolicy(sasPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [StorageAccountArgs].
 */
@PulumiTagMarker
public class StorageAccountArgsBuilder internal constructor() {
    private var accessTier: Output<AccessTier>? = null

    private var accountName: Output<String>? = null

    private var allowBlobPublicAccess: Output<Boolean>? = null

    private var allowCrossTenantReplication: Output<Boolean>? = null

    private var allowSharedKeyAccess: Output<Boolean>? = null

    private var allowedCopyScope: Output<Either<String, AllowedCopyScope>>? = null

    private var azureFilesIdentityBasedAuthentication:
        Output<AzureFilesIdentityBasedAuthenticationArgs>? = null

    private var customDomain: Output<CustomDomainArgs>? = null

    private var defaultToOAuthAuthentication: Output<Boolean>? = null

    private var dnsEndpointType: Output<Either<String, DnsEndpointType>>? = null

    private var enableHttpsTrafficOnly: Output<Boolean>? = null

    private var enableNfsV3: Output<Boolean>? = null

    private var encryption: Output<EncryptionArgs>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var identity: Output<IdentityArgs>? = null

    private var immutableStorageWithVersioning: Output<ImmutableStorageAccountArgs>? = null

    private var isHnsEnabled: Output<Boolean>? = null

    private var isLocalUserEnabled: Output<Boolean>? = null

    private var isSftpEnabled: Output<Boolean>? = null

    private var keyPolicy: Output<KeyPolicyArgs>? = null

    private var kind: Output<Either<String, Kind>>? = null

    private var largeFileSharesState: Output<Either<String, LargeFileSharesState>>? = null

    private var location: Output<String>? = null

    private var minimumTlsVersion: Output<Either<String, MinimumTlsVersion>>? = null

    private var networkRuleSet: Output<NetworkRuleSetArgs>? = null

    private var publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null

    private var resourceGroupName: Output<String>? = null

    private var routingPreference: Output<RoutingPreferenceArgs>? = null

    private var sasPolicy: Output<SasPolicyArgs>? = null

    private var sku: Output<SkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Required for storage accounts where kind = BlobStorage. The access tier is used for billing. The 'Premium' access tier is the default value for premium block blobs storage account type and it cannot be changed for the premium block blobs storage account type.
     */
    @JvmName("klnsfhdqonbqfswe")
    public suspend fun accessTier(`value`: Output<AccessTier>) {
        this.accessTier = value
    }

    /**
     * @param value The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("cwwnwebyjxiqwiff")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Allow or disallow public access to all blobs or containers in the storage account. The default interpretation is true for this property.
     */
    @JvmName("jstomqfnpqfwuxeq")
    public suspend fun allowBlobPublicAccess(`value`: Output<Boolean>) {
        this.allowBlobPublicAccess = value
    }

    /**
     * @param value Allow or disallow cross AAD tenant object replication. The default interpretation is true for this property.
     */
    @JvmName("pksjgrtjquakdold")
    public suspend fun allowCrossTenantReplication(`value`: Output<Boolean>) {
        this.allowCrossTenantReplication = value
    }

    /**
     * @param value Indicates whether the storage account permits requests to be authorized with the account access key via Shared Key. If false, then all requests, including shared access signatures, must be authorized with Azure Active Directory (Azure AD). The default value is null, which is equivalent to true.
     */
    @JvmName("iijhkcuobnipowfw")
    public suspend fun allowSharedKeyAccess(`value`: Output<Boolean>) {
        this.allowSharedKeyAccess = value
    }

    /**
     * @param value Restrict copy to and from Storage Accounts within an AAD tenant or with Private Links to the same VNet.
     */
    @JvmName("dcbjcxcclvxpmqwj")
    public suspend fun allowedCopyScope(`value`: Output<Either<String, AllowedCopyScope>>) {
        this.allowedCopyScope = value
    }

    /**
     * @param value Provides the identity based authentication settings for Azure Files.
     */
    @JvmName("uhgshswwadxrssoe")
    public suspend
    fun azureFilesIdentityBasedAuthentication(`value`: Output<AzureFilesIdentityBasedAuthenticationArgs>) {
        this.azureFilesIdentityBasedAuthentication = value
    }

    /**
     * @param value User domain assigned to the storage account. Name is the CNAME source. Only one custom domain is supported per storage account at this time. To clear the existing custom domain, use an empty string for the custom domain name property.
     */
    @JvmName("rrafgdmrplabavwm")
    public suspend fun customDomain(`value`: Output<CustomDomainArgs>) {
        this.customDomain = value
    }

    /**
     * @param value A boolean flag which indicates whether the default authentication is OAuth or not. The default interpretation is false for this property.
     */
    @JvmName("fgkpaefhjjvaksal")
    public suspend fun defaultToOAuthAuthentication(`value`: Output<Boolean>) {
        this.defaultToOAuthAuthentication = value
    }

    /**
     * @param value Allows you to specify the type of endpoint. Set this to AzureDNSZone to create a large number of accounts in a single subscription, which creates accounts in an Azure DNS Zone and the endpoint URL will have an alphanumeric DNS Zone identifier.
     */
    @JvmName("ctkcwctjftcrspmw")
    public suspend fun dnsEndpointType(`value`: Output<Either<String, DnsEndpointType>>) {
        this.dnsEndpointType = value
    }

    /**
     * @param value Allows https traffic only to storage service if sets to true. The default value is true since API version 2019-04-01.
     */
    @JvmName("rtfcbikriklcadco")
    public suspend fun enableHttpsTrafficOnly(`value`: Output<Boolean>) {
        this.enableHttpsTrafficOnly = value
    }

    /**
     * @param value NFS 3.0 protocol support enabled if set to true.
     */
    @JvmName("wwlcmlnjqneybdyh")
    public suspend fun enableNfsV3(`value`: Output<Boolean>) {
        this.enableNfsV3 = value
    }

    /**
     * @param value Encryption settings to be used for server-side encryption for the storage account.
     */
    @JvmName("tjfigcpxsisbrktq")
    public suspend fun encryption(`value`: Output<EncryptionArgs>) {
        this.encryption = value
    }

    /**
     * @param value Optional. Set the extended location of the resource. If not set, the storage account will be created in Azure main region. Otherwise it will be created in the specified extended location
     */
    @JvmName("innbpbfvmtmpebkh")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The identity of the resource.
     */
    @JvmName("otnsvssjpcnmylpp")
    public suspend fun identity(`value`: Output<IdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The property is immutable and can only be set to true at the account creation time. When set to true, it enables object level immutability for all the new containers in the account by default.
     */
    @JvmName("eqhyrbtvwoukyimq")
    public suspend fun immutableStorageWithVersioning(`value`: Output<ImmutableStorageAccountArgs>) {
        this.immutableStorageWithVersioning = value
    }

    /**
     * @param value Account HierarchicalNamespace enabled if sets to true.
     */
    @JvmName("fflyjxgitvaepiia")
    public suspend fun isHnsEnabled(`value`: Output<Boolean>) {
        this.isHnsEnabled = value
    }

    /**
     * @param value Enables local users feature, if set to true
     */
    @JvmName("pdlgyoiyibwgygfr")
    public suspend fun isLocalUserEnabled(`value`: Output<Boolean>) {
        this.isLocalUserEnabled = value
    }

    /**
     * @param value Enables Secure File Transfer Protocol, if set to true
     */
    @JvmName("uomositaglswseku")
    public suspend fun isSftpEnabled(`value`: Output<Boolean>) {
        this.isSftpEnabled = value
    }

    /**
     * @param value KeyPolicy assigned to the storage account.
     */
    @JvmName("ypjorwsjuwwspepu")
    public suspend fun keyPolicy(`value`: Output<KeyPolicyArgs>) {
        this.keyPolicy = value
    }

    /**
     * @param value Required. Indicates the type of storage account.
     */
    @JvmName("lqpcfumftxjqeujm")
    public suspend fun kind(`value`: Output<Either<String, Kind>>) {
        this.kind = value
    }

    /**
     * @param value Allow large file shares if sets to Enabled. It cannot be disabled once it is enabled.
     */
    @JvmName("pqvglhfauaouhbcq")
    public suspend fun largeFileSharesState(`value`: Output<Either<String, LargeFileSharesState>>) {
        this.largeFileSharesState = value
    }

    /**
     * @param value Required. Gets or sets the location of the resource. This will be one of the supported and registered Azure Geo Regions (e.g. West US, East US, Southeast Asia, etc.). The geo region of a resource cannot be changed once it is created, but if an identical geo region is specified on update, the request will succeed.
     */
    @JvmName("gcnmocujafxslplj")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Set the minimum TLS version to be permitted on requests to storage. The default interpretation is TLS 1.0 for this property.
     */
    @JvmName("ajdqjkqgopmgauqp")
    public suspend fun minimumTlsVersion(`value`: Output<Either<String, MinimumTlsVersion>>) {
        this.minimumTlsVersion = value
    }

    /**
     * @param value Network rule set
     */
    @JvmName("ocyuentygkbcjxgr")
    public suspend fun networkRuleSet(`value`: Output<NetworkRuleSetArgs>) {
        this.networkRuleSet = value
    }

    /**
     * @param value Allow or disallow public network access to Storage Account. Value is optional but if passed in, must be 'Enabled' or 'Disabled'.
     */
    @JvmName("eaqiwcyhqcrqexny")
    public suspend fun publicNetworkAccess(`value`: Output<Either<String, PublicNetworkAccess>>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("rgrwuersekliokil")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Maintains information about the network routing choice opted by the user for data transfer
     */
    @JvmName("jnirvmqhcnqvmkut")
    public suspend fun routingPreference(`value`: Output<RoutingPreferenceArgs>) {
        this.routingPreference = value
    }

    /**
     * @param value SasPolicy assigned to the storage account.
     */
    @JvmName("vopjxabwowetvhuf")
    public suspend fun sasPolicy(`value`: Output<SasPolicyArgs>) {
        this.sasPolicy = value
    }

    /**
     * @param value Required. Gets or sets the SKU name.
     */
    @JvmName("ahwsnkrciggvtcsx")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Gets or sets a list of key value pairs that describe the resource. These tags can be used for viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key with a length no greater than 128 characters and a value with a length no greater than 256 characters.
     */
    @JvmName("aertlewfgsosmdsq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Required for storage accounts where kind = BlobStorage. The access tier is used for billing. The 'Premium' access tier is the default value for premium block blobs storage account type and it cannot be changed for the premium block blobs storage account type.
     */
    @JvmName("grrmarytgytaontt")
    public suspend fun accessTier(`value`: AccessTier?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessTier = mapped
    }

    /**
     * @param value The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("dbvvrhpgbgyuyvnw")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Allow or disallow public access to all blobs or containers in the storage account. The default interpretation is true for this property.
     */
    @JvmName("wbuujqyekyaigmyn")
    public suspend fun allowBlobPublicAccess(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowBlobPublicAccess = mapped
    }

    /**
     * @param value Allow or disallow cross AAD tenant object replication. The default interpretation is true for this property.
     */
    @JvmName("hgkacjxlfkbqafrs")
    public suspend fun allowCrossTenantReplication(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowCrossTenantReplication = mapped
    }

    /**
     * @param value Indicates whether the storage account permits requests to be authorized with the account access key via Shared Key. If false, then all requests, including shared access signatures, must be authorized with Azure Active Directory (Azure AD). The default value is null, which is equivalent to true.
     */
    @JvmName("njnkxfgdqsenpxis")
    public suspend fun allowSharedKeyAccess(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowSharedKeyAccess = mapped
    }

    /**
     * @param value Restrict copy to and from Storage Accounts within an AAD tenant or with Private Links to the same VNet.
     */
    @JvmName("ubxsmjwnmijcroqn")
    public suspend fun allowedCopyScope(`value`: Either<String, AllowedCopyScope>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedCopyScope = mapped
    }

    /**
     * @param value Restrict copy to and from Storage Accounts within an AAD tenant or with Private Links to the same VNet.
     */
    @JvmName("auvcpqyuidxkcndr")
    public fun allowedCopyScope(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AllowedCopyScope>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedCopyScope = mapped
    }

    /**
     * @param value Restrict copy to and from Storage Accounts within an AAD tenant or with Private Links to the same VNet.
     */
    @JvmName("biuueuexlolkrugw")
    public fun allowedCopyScope(`value`: AllowedCopyScope) {
        val toBeMapped = Either.ofRight<String, AllowedCopyScope>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedCopyScope = mapped
    }

    /**
     * @param value Provides the identity based authentication settings for Azure Files.
     */
    @JvmName("yfyqlxwrocuxfxmf")
    public suspend
    fun azureFilesIdentityBasedAuthentication(`value`: AzureFilesIdentityBasedAuthenticationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureFilesIdentityBasedAuthentication = mapped
    }

    /**
     * @param argument Provides the identity based authentication settings for Azure Files.
     */
    @JvmName("dxwasudfxkbwxlxe")
    public suspend
    fun azureFilesIdentityBasedAuthentication(argument: suspend AzureFilesIdentityBasedAuthenticationArgsBuilder.() -> Unit) {
        val toBeMapped = AzureFilesIdentityBasedAuthenticationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.azureFilesIdentityBasedAuthentication = mapped
    }

    /**
     * @param value User domain assigned to the storage account. Name is the CNAME source. Only one custom domain is supported per storage account at this time. To clear the existing custom domain, use an empty string for the custom domain name property.
     */
    @JvmName("bpvevucgallesvdv")
    public suspend fun customDomain(`value`: CustomDomainArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customDomain = mapped
    }

    /**
     * @param argument User domain assigned to the storage account. Name is the CNAME source. Only one custom domain is supported per storage account at this time. To clear the existing custom domain, use an empty string for the custom domain name property.
     */
    @JvmName("rvcdgnovhwrnjkqh")
    public suspend fun customDomain(argument: suspend CustomDomainArgsBuilder.() -> Unit) {
        val toBeMapped = CustomDomainArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.customDomain = mapped
    }

    /**
     * @param value A boolean flag which indicates whether the default authentication is OAuth or not. The default interpretation is false for this property.
     */
    @JvmName("xjexhcbjinoibpqx")
    public suspend fun defaultToOAuthAuthentication(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultToOAuthAuthentication = mapped
    }

    /**
     * @param value Allows you to specify the type of endpoint. Set this to AzureDNSZone to create a large number of accounts in a single subscription, which creates accounts in an Azure DNS Zone and the endpoint URL will have an alphanumeric DNS Zone identifier.
     */
    @JvmName("djqmseweabggtcxw")
    public suspend fun dnsEndpointType(`value`: Either<String, DnsEndpointType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsEndpointType = mapped
    }

    /**
     * @param value Allows you to specify the type of endpoint. Set this to AzureDNSZone to create a large number of accounts in a single subscription, which creates accounts in an Azure DNS Zone and the endpoint URL will have an alphanumeric DNS Zone identifier.
     */
    @JvmName("bmfxjixvlmnaoekd")
    public fun dnsEndpointType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DnsEndpointType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dnsEndpointType = mapped
    }

    /**
     * @param value Allows you to specify the type of endpoint. Set this to AzureDNSZone to create a large number of accounts in a single subscription, which creates accounts in an Azure DNS Zone and the endpoint URL will have an alphanumeric DNS Zone identifier.
     */
    @JvmName("crsyovjbusfspikj")
    public fun dnsEndpointType(`value`: DnsEndpointType) {
        val toBeMapped = Either.ofRight<String, DnsEndpointType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dnsEndpointType = mapped
    }

    /**
     * @param value Allows https traffic only to storage service if sets to true. The default value is true since API version 2019-04-01.
     */
    @JvmName("axxvryeipsguxear")
    public suspend fun enableHttpsTrafficOnly(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableHttpsTrafficOnly = mapped
    }

    /**
     * @param value NFS 3.0 protocol support enabled if set to true.
     */
    @JvmName("pbilvsmyqayicluy")
    public suspend fun enableNfsV3(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableNfsV3 = mapped
    }

    /**
     * @param value Encryption settings to be used for server-side encryption for the storage account.
     */
    @JvmName("gsfycupusrsgsyau")
    public suspend fun encryption(`value`: EncryptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryption = mapped
    }

    /**
     * @param argument Encryption settings to be used for server-side encryption for the storage account.
     */
    @JvmName("qgillbkrsadnvtxn")
    public suspend fun encryption(argument: suspend EncryptionArgsBuilder.() -> Unit) {
        val toBeMapped = EncryptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryption = mapped
    }

    /**
     * @param value Optional. Set the extended location of the resource. If not set, the storage account will be created in Azure main region. Otherwise it will be created in the specified extended location
     */
    @JvmName("ktbyhkuuksicrpqm")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument Optional. Set the extended location of the resource. If not set, the storage account will be created in Azure main region. Otherwise it will be created in the specified extended location
     */
    @JvmName("thciwvkplflqpwqq")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The identity of the resource.
     */
    @JvmName("ijcsokwfvresxxvr")
    public suspend fun identity(`value`: IdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The identity of the resource.
     */
    @JvmName("xcjwflqffdmlgfck")
    public suspend fun identity(argument: suspend IdentityArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The property is immutable and can only be set to true at the account creation time. When set to true, it enables object level immutability for all the new containers in the account by default.
     */
    @JvmName("gvshhqijjtfvbxnc")
    public suspend fun immutableStorageWithVersioning(`value`: ImmutableStorageAccountArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.immutableStorageWithVersioning = mapped
    }

    /**
     * @param argument The property is immutable and can only be set to true at the account creation time. When set to true, it enables object level immutability for all the new containers in the account by default.
     */
    @JvmName("gbmbccoeuqpwyqel")
    public suspend
    fun immutableStorageWithVersioning(argument: suspend ImmutableStorageAccountArgsBuilder.() -> Unit) {
        val toBeMapped = ImmutableStorageAccountArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.immutableStorageWithVersioning = mapped
    }

    /**
     * @param value Account HierarchicalNamespace enabled if sets to true.
     */
    @JvmName("olmkyxoaxtcjqsfp")
    public suspend fun isHnsEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isHnsEnabled = mapped
    }

    /**
     * @param value Enables local users feature, if set to true
     */
    @JvmName("brsrhnaptdbwygsn")
    public suspend fun isLocalUserEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isLocalUserEnabled = mapped
    }

    /**
     * @param value Enables Secure File Transfer Protocol, if set to true
     */
    @JvmName("acninhurlhcnyhdm")
    public suspend fun isSftpEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isSftpEnabled = mapped
    }

    /**
     * @param value KeyPolicy assigned to the storage account.
     */
    @JvmName("xkevqjerdstowvtp")
    public suspend fun keyPolicy(`value`: KeyPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyPolicy = mapped
    }

    /**
     * @param argument KeyPolicy assigned to the storage account.
     */
    @JvmName("cffuvvunygtcgspt")
    public suspend fun keyPolicy(argument: suspend KeyPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = KeyPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.keyPolicy = mapped
    }

    /**
     * @param value Required. Indicates the type of storage account.
     */
    @JvmName("epiivwgykgsmmkrr")
    public suspend fun kind(`value`: Either<String, Kind>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Required. Indicates the type of storage account.
     */
    @JvmName("viqonmfjkvourcmk")
    public fun kind(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Kind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Required. Indicates the type of storage account.
     */
    @JvmName("qonlcbkufcwgcmfx")
    public fun kind(`value`: Kind) {
        val toBeMapped = Either.ofRight<String, Kind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Allow large file shares if sets to Enabled. It cannot be disabled once it is enabled.
     */
    @JvmName("shtwkkgqxhpdbykb")
    public suspend fun largeFileSharesState(`value`: Either<String, LargeFileSharesState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.largeFileSharesState = mapped
    }

    /**
     * @param value Allow large file shares if sets to Enabled. It cannot be disabled once it is enabled.
     */
    @JvmName("pjxlyeimlietnpti")
    public fun largeFileSharesState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LargeFileSharesState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.largeFileSharesState = mapped
    }

    /**
     * @param value Allow large file shares if sets to Enabled. It cannot be disabled once it is enabled.
     */
    @JvmName("waqbuvqwtjljjjgf")
    public fun largeFileSharesState(`value`: LargeFileSharesState) {
        val toBeMapped = Either.ofRight<String, LargeFileSharesState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.largeFileSharesState = mapped
    }

    /**
     * @param value Required. Gets or sets the location of the resource. This will be one of the supported and registered Azure Geo Regions (e.g. West US, East US, Southeast Asia, etc.). The geo region of a resource cannot be changed once it is created, but if an identical geo region is specified on update, the request will succeed.
     */
    @JvmName("iefncvcqmxmivmgn")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Set the minimum TLS version to be permitted on requests to storage. The default interpretation is TLS 1.0 for this property.
     */
    @JvmName("keicytvrvnammfqc")
    public suspend fun minimumTlsVersion(`value`: Either<String, MinimumTlsVersion>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minimumTlsVersion = mapped
    }

    /**
     * @param value Set the minimum TLS version to be permitted on requests to storage. The default interpretation is TLS 1.0 for this property.
     */
    @JvmName("ojdepdxloxvitsrl")
    public fun minimumTlsVersion(`value`: String) {
        val toBeMapped = Either.ofLeft<String, MinimumTlsVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minimumTlsVersion = mapped
    }

    /**
     * @param value Set the minimum TLS version to be permitted on requests to storage. The default interpretation is TLS 1.0 for this property.
     */
    @JvmName("bxkwhadqsdhxlckc")
    public fun minimumTlsVersion(`value`: MinimumTlsVersion) {
        val toBeMapped = Either.ofRight<String, MinimumTlsVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minimumTlsVersion = mapped
    }

    /**
     * @param value Network rule set
     */
    @JvmName("ftcwwgmnqtrwgftf")
    public suspend fun networkRuleSet(`value`: NetworkRuleSetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkRuleSet = mapped
    }

    /**
     * @param argument Network rule set
     */
    @JvmName("rydhtwqdqclrkcsn")
    public suspend fun networkRuleSet(argument: suspend NetworkRuleSetArgsBuilder.() -> Unit) {
        val toBeMapped = NetworkRuleSetArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkRuleSet = mapped
    }

    /**
     * @param value Allow or disallow public network access to Storage Account. Value is optional but if passed in, must be 'Enabled' or 'Disabled'.
     */
    @JvmName("gmjdpmlthbgpcpsh")
    public suspend fun publicNetworkAccess(`value`: Either<String, PublicNetworkAccess>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Allow or disallow public network access to Storage Account. Value is optional but if passed in, must be 'Enabled' or 'Disabled'.
     */
    @JvmName("vpbxauomadfvctva")
    public fun publicNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Allow or disallow public network access to Storage Account. Value is optional but if passed in, must be 'Enabled' or 'Disabled'.
     */
    @JvmName("loesyibpxhxgjueq")
    public fun publicNetworkAccess(`value`: PublicNetworkAccess) {
        val toBeMapped = Either.ofRight<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("kepsovhmvgiyhhnu")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Maintains information about the network routing choice opted by the user for data transfer
     */
    @JvmName("ouddvyngtwwtcyrv")
    public suspend fun routingPreference(`value`: RoutingPreferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routingPreference = mapped
    }

    /**
     * @param argument Maintains information about the network routing choice opted by the user for data transfer
     */
    @JvmName("avfcpemlbyucqvei")
    public suspend fun routingPreference(argument: suspend RoutingPreferenceArgsBuilder.() -> Unit) {
        val toBeMapped = RoutingPreferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.routingPreference = mapped
    }

    /**
     * @param value SasPolicy assigned to the storage account.
     */
    @JvmName("iojajjlofetkvhkh")
    public suspend fun sasPolicy(`value`: SasPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sasPolicy = mapped
    }

    /**
     * @param argument SasPolicy assigned to the storage account.
     */
    @JvmName("huhgwrvufmniymne")
    public suspend fun sasPolicy(argument: suspend SasPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = SasPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sasPolicy = mapped
    }

    /**
     * @param value Required. Gets or sets the SKU name.
     */
    @JvmName("yefxherkhnojtdgb")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument Required. Gets or sets the SKU name.
     */
    @JvmName("advwqwbewufjqipi")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Gets or sets a list of key value pairs that describe the resource. These tags can be used for viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key with a length no greater than 128 characters and a value with a length no greater than 256 characters.
     */
    @JvmName("stdewhcikfirrdsy")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Gets or sets a list of key value pairs that describe the resource. These tags can be used for viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key with a length no greater than 128 characters and a value with a length no greater than 256 characters.
     */
    @JvmName("snxpoxmkfpoovyvr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): StorageAccountArgs = StorageAccountArgs(
        accessTier = accessTier,
        accountName = accountName,
        allowBlobPublicAccess = allowBlobPublicAccess,
        allowCrossTenantReplication = allowCrossTenantReplication,
        allowSharedKeyAccess = allowSharedKeyAccess,
        allowedCopyScope = allowedCopyScope,
        azureFilesIdentityBasedAuthentication = azureFilesIdentityBasedAuthentication,
        customDomain = customDomain,
        defaultToOAuthAuthentication = defaultToOAuthAuthentication,
        dnsEndpointType = dnsEndpointType,
        enableHttpsTrafficOnly = enableHttpsTrafficOnly,
        enableNfsV3 = enableNfsV3,
        encryption = encryption,
        extendedLocation = extendedLocation,
        identity = identity,
        immutableStorageWithVersioning = immutableStorageWithVersioning,
        isHnsEnabled = isHnsEnabled,
        isLocalUserEnabled = isLocalUserEnabled,
        isSftpEnabled = isSftpEnabled,
        keyPolicy = keyPolicy,
        kind = kind,
        largeFileSharesState = largeFileSharesState,
        location = location,
        minimumTlsVersion = minimumTlsVersion,
        networkRuleSet = networkRuleSet,
        publicNetworkAccess = publicNetworkAccess,
        resourceGroupName = resourceGroupName,
        routingPreference = routingPreference,
        sasPolicy = sasPolicy,
        sku = sku,
        tags = tags,
    )
}
