@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin

import com.pulumi.azurenative.storage.TableServicePropertiesArgs.builder
import com.pulumi.azurenative.storage.kotlin.inputs.CorsRulesArgs
import com.pulumi.azurenative.storage.kotlin.inputs.CorsRulesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The properties of a storage account’s Table service.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2021-02-01.
 * Other available API versions: 2023-01-01.
 * ## Example Usage
 * ### TableServicesPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var tableServiceProperties = new AzureNative.Storage.TableServiceProperties("tableServiceProperties", new()
 *     {
 *         AccountName = "sto8607",
 *         Cors = new AzureNative.Storage.Inputs.CorsRulesArgs
 *         {
 *             CorsRules = new[]
 *             {
 *                 new AzureNative.Storage.Inputs.CorsRuleArgs
 *                 {
 *                     AllowedHeaders = new[]
 *                     {
 *                         "x-ms-meta-abc",
 *                         "x-ms-meta-data*",
 *                         "x-ms-meta-target*",
 *                     },
 *                     AllowedMethods = new[]
 *                     {
 *                         "GET",
 *                         "HEAD",
 *                         "POST",
 *                         "OPTIONS",
 *                         "MERGE",
 *                         "PUT",
 *                     },
 *                     AllowedOrigins = new[]
 *                     {
 *                         "http://www.contoso.com",
 *                         "http://www.fabrikam.com",
 *                     },
 *                     ExposedHeaders = new[]
 *                     {
 *                         "x-ms-meta-*",
 *                     },
 *                     MaxAgeInSeconds = 100,
 *                 },
 *                 new AzureNative.Storage.Inputs.CorsRuleArgs
 *                 {
 *                     AllowedHeaders = new[]
 *                     {
 *                         "*",
 *                     },
 *                     AllowedMethods = new[]
 *                     {
 *                         "GET",
 *                     },
 *                     AllowedOrigins = new[]
 *                     {
 *                         "*",
 *                     },
 *                     ExposedHeaders = new[]
 *                     {
 *                         "*",
 *                     },
 *                     MaxAgeInSeconds = 2,
 *                 },
 *                 new AzureNative.Storage.Inputs.CorsRuleArgs
 *                 {
 *                     AllowedHeaders = new[]
 *                     {
 *                         "x-ms-meta-12345675754564*",
 *                     },
 *                     AllowedMethods = new[]
 *                     {
 *                         "GET",
 *                         "PUT",
 *                     },
 *                     AllowedOrigins = new[]
 *                     {
 *                         "http://www.abc23.com",
 *                         "https://www.fabrikam.com/*",
 *                     },
 *                     ExposedHeaders = new[]
 *                     {
 *                         "x-ms-meta-abc",
 *                         "x-ms-meta-data*",
 *                         "x-ms-meta-target*",
 *                     },
 *                     MaxAgeInSeconds = 2000,
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "res4410",
 *         TableServiceName = "default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewTableServiceProperties(ctx, "tableServiceProperties", &storage.TableServicePropertiesArgs{
 * 			AccountName: pulumi.String("sto8607"),
 * 			Cors: storage.CorsRulesResponse{
 * 				CorsRules: storage.CorsRuleArray{
 * 					&storage.CorsRuleArgs{
 * 						AllowedHeaders: pulumi.StringArray{
 * 							pulumi.String("x-ms-meta-abc"),
 * 							pulumi.String("x-ms-meta-data*"),
 * 							pulumi.String("x-ms-meta-target*"),
 * 						},
 * 						AllowedMethods: pulumi.StringArray{
 * 							pulumi.String("GET"),
 * 							pulumi.String("HEAD"),
 * 							pulumi.String("POST"),
 * 							pulumi.String("OPTIONS"),
 * 							pulumi.String("MERGE"),
 * 							pulumi.String("PUT"),
 * 						},
 * 						AllowedOrigins: pulumi.StringArray{
 * 							pulumi.String("http://www.contoso.com"),
 * 							pulumi.String("http://www.fabrikam.com"),
 * 						},
 * 						ExposedHeaders: pulumi.StringArray{
 * 							pulumi.String("x-ms-meta-*"),
 * 						},
 * 						MaxAgeInSeconds: pulumi.Int(100),
 * 					},
 * 					&storage.CorsRuleArgs{
 * 						AllowedHeaders: pulumi.StringArray{
 * 							pulumi.String("*"),
 * 						},
 * 						AllowedMethods: pulumi.StringArray{
 * 							pulumi.String("GET"),
 * 						},
 * 						AllowedOrigins: pulumi.StringArray{
 * 							pulumi.String("*"),
 * 						},
 * 						ExposedHeaders: pulumi.StringArray{
 * 							pulumi.String("*"),
 * 						},
 * 						MaxAgeInSeconds: pulumi.Int(2),
 * 					},
 * 					&storage.CorsRuleArgs{
 * 						AllowedHeaders: pulumi.StringArray{
 * 							pulumi.String("x-ms-meta-12345675754564*"),
 * 						},
 * 						AllowedMethods: pulumi.StringArray{
 * 							pulumi.String("GET"),
 * 							pulumi.String("PUT"),
 * 						},
 * 						AllowedOrigins: pulumi.StringArray{
 * 							pulumi.String("http://www.abc23.com"),
 * 							pulumi.String("https://www.fabrikam.com/*"),
 * 						},
 * 						ExposedHeaders: pulumi.StringArray{
 * 							pulumi.String("x-ms-meta-abc"),
 * 							pulumi.String("x-ms-meta-data*"),
 * 							pulumi.String("x-ms-meta-target*"),
 * 						},
 * 						MaxAgeInSeconds: pulumi.Int(2000),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("res4410"),
 * 			TableServiceName:  pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.TableServiceProperties;
 * import com.pulumi.azurenative.storage.TableServicePropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var tableServiceProperties = new TableServiceProperties("tableServiceProperties", TableServicePropertiesArgs.builder()
 *             .accountName("sto8607")
 *             .cors(Map.of("corsRules",
 *                 Map.ofEntries(
 *                     Map.entry("allowedHeaders",
 *                         "x-ms-meta-abc",
 *                         "x-ms-meta-data*",
 *                         "x-ms-meta-target*"),
 *                     Map.entry("allowedMethods",
 *                         "GET",
 *                         "HEAD",
 *                         "POST",
 *                         "OPTIONS",
 *                         "MERGE",
 *                         "PUT"),
 *                     Map.entry("allowedOrigins",
 *                         "http://www.contoso.com",
 *                         "http://www.fabrikam.com"),
 *                     Map.entry("exposedHeaders", "x-ms-meta-*"),
 *                     Map.entry("maxAgeInSeconds", 100)
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("allowedHeaders", "*"),
 *                     Map.entry("allowedMethods", "GET"),
 *                     Map.entry("allowedOrigins", "*"),
 *                     Map.entry("exposedHeaders", "*"),
 *                     Map.entry("maxAgeInSeconds", 2)
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("allowedHeaders", "x-ms-meta-12345675754564*"),
 *                     Map.entry("allowedMethods",
 *                         "GET",
 *                         "PUT"),
 *                     Map.entry("allowedOrigins",
 *                         "http://www.abc23.com",
 *                         "https://www.fabrikam.com/*"),
 *                     Map.entry("exposedHeaders",
 *                         "x-ms-meta-abc",
 *                         "x-ms-meta-data*",
 *                         "x-ms-meta-target*"),
 *                     Map.entry("maxAgeInSeconds", 2000)
 *                 )))
 *             .resourceGroupName("res4410")
 *             .tableServiceName("default")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storage:TableServiceProperties default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/tableServices/{tableServiceName}
 * ```
 * @property accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
 * @property cors Specifies CORS rules for the Table service. You can include up to five CorsRule elements in the request. If no CorsRule elements are included in the request body, all CORS rules will be deleted, and CORS will be disabled for the Table service.
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 * @property tableServiceName The name of the Table Service within the specified storage account. Table Service Name must be 'default'
 * */*/*/
 */
public data class TableServicePropertiesArgs(
    public val accountName: Output<String>? = null,
    public val cors: Output<CorsRulesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tableServiceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.TableServicePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.TableServicePropertiesArgs =
        com.pulumi.azurenative.storage.TableServicePropertiesArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .cors(cors?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tableServiceName(tableServiceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TableServicePropertiesArgs].
 */
@PulumiTagMarker
public class TableServicePropertiesArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var cors: Output<CorsRulesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tableServiceName: Output<String>? = null

    /**
     * @param value The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("edghyrfoxuiyxbro")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Specifies CORS rules for the Table service. You can include up to five CorsRule elements in the request. If no CorsRule elements are included in the request body, all CORS rules will be deleted, and CORS will be disabled for the Table service.
     */
    @JvmName("qnaomsopeubmlqux")
    public suspend fun cors(`value`: Output<CorsRulesArgs>) {
        this.cors = value
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("qwshlcrrpqlprgrn")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Table Service within the specified storage account. Table Service Name must be 'default'
     */
    @JvmName("dawidluamtmpawbl")
    public suspend fun tableServiceName(`value`: Output<String>) {
        this.tableServiceName = value
    }

    /**
     * @param value The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("fcytevgaiqafovkv")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Specifies CORS rules for the Table service. You can include up to five CorsRule elements in the request. If no CorsRule elements are included in the request body, all CORS rules will be deleted, and CORS will be disabled for the Table service.
     */
    @JvmName("fwioilfvdcwawtwl")
    public suspend fun cors(`value`: CorsRulesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cors = mapped
    }

    /**
     * @param argument Specifies CORS rules for the Table service. You can include up to five CorsRule elements in the request. If no CorsRule elements are included in the request body, all CORS rules will be deleted, and CORS will be disabled for the Table service.
     */
    @JvmName("ldlpuwppcoewhpxl")
    public suspend fun cors(argument: suspend CorsRulesArgsBuilder.() -> Unit) {
        val toBeMapped = CorsRulesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cors = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("nifgshxinaooujtd")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Table Service within the specified storage account. Table Service Name must be 'default'
     */
    @JvmName("ieaafgdrfwphdxmn")
    public suspend fun tableServiceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableServiceName = mapped
    }

    internal fun build(): TableServicePropertiesArgs = TableServicePropertiesArgs(
        accountName = accountName,
        cors = cors,
        resourceGroupName = resourceGroupName,
        tableServiceName = tableServiceName,
    )
}
