@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Required for storage accounts where kind = BlobStorage. The access tier is used for billing. The 'Premium' access tier is the default value for premium block blobs storage account type and it cannot be changed for the premium block blobs storage account type.
 */
public enum class AccessTier(
    public val javaValue: com.pulumi.azurenative.storage.enums.AccessTier,
) : ConvertibleToJava<com.pulumi.azurenative.storage.enums.AccessTier> {
    Hot(com.pulumi.azurenative.storage.enums.AccessTier.Hot),
    Cool(com.pulumi.azurenative.storage.enums.AccessTier.Cool),
    Premium(com.pulumi.azurenative.storage.enums.AccessTier.Premium),
    ;

    override fun toJava(): com.pulumi.azurenative.storage.enums.AccessTier = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.enums.AccessTier): AccessTier =
            AccessTier.values().first { it.javaValue == javaType }
    }
}
