@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The ImmutabilityPolicy state defines the mode of the policy. Disabled state disables the policy, Unlocked state allows increase and decrease of immutability retention time and also allows toggling allowProtectedAppendWrites property, Locked state only allows the increase of the immutability retention time. A policy can only be created in a Disabled or Unlocked state and can be toggled between the two states. Only a policy in an Unlocked state can transition to a Locked state which cannot be reverted.
 */
public enum class AccountImmutabilityPolicyState(
    public val javaValue: com.pulumi.azurenative.storage.enums.AccountImmutabilityPolicyState,
) : ConvertibleToJava<com.pulumi.azurenative.storage.enums.AccountImmutabilityPolicyState> {
    Unlocked(com.pulumi.azurenative.storage.enums.AccountImmutabilityPolicyState.Unlocked),
    Locked(com.pulumi.azurenative.storage.enums.AccountImmutabilityPolicyState.Locked),
    Disabled(com.pulumi.azurenative.storage.enums.AccountImmutabilityPolicyState.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.storage.enums.AccountImmutabilityPolicyState =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storage.enums.AccountImmutabilityPolicyState):
            AccountImmutabilityPolicyState =
            AccountImmutabilityPolicyState.values().first { it.javaValue == javaType }
    }
}
