@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The access tier of a storage blob.
 */
public enum class BlobAccessTier(
    public val javaValue: com.pulumi.azurenative.storage.enums.BlobAccessTier,
) : ConvertibleToJava<com.pulumi.azurenative.storage.enums.BlobAccessTier> {
    /**
     * Optimized for storing data that is accessed frequently.
     */
    Hot(com.pulumi.azurenative.storage.enums.BlobAccessTier.Hot),

    /**
     * Optimized for storing data that is infrequently accessed and stored for at least 30 days.
     */
    Cool(com.pulumi.azurenative.storage.enums.BlobAccessTier.Cool),

    /**
     * Optimized for storing data that is rarely accessed and stored for at least 180 days with flexible latency requirements, on the order of hours.
     */
    Archive(com.pulumi.azurenative.storage.enums.BlobAccessTier.Archive),
    ;

    override fun toJava(): com.pulumi.azurenative.storage.enums.BlobAccessTier = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.enums.BlobAccessTier):
            BlobAccessTier = BlobAccessTier.values().first { it.javaValue == javaType }
    }
}
