@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The state of the encryption scope. Possible values (case-insensitive):  Enabled, Disabled.
 */
public enum class EncryptionScopeState(
    public val javaValue: com.pulumi.azurenative.storage.enums.EncryptionScopeState,
) : ConvertibleToJava<com.pulumi.azurenative.storage.enums.EncryptionScopeState> {
    Enabled(com.pulumi.azurenative.storage.enums.EncryptionScopeState.Enabled),
    Disabled(com.pulumi.azurenative.storage.enums.EncryptionScopeState.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.storage.enums.EncryptionScopeState = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.enums.EncryptionScopeState):
            EncryptionScopeState = EncryptionScopeState.values().first { it.javaValue == javaType }
    }
}
