@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The encryption keySource (provider). Possible values (case-insensitive):  Microsoft.Storage, Microsoft.Keyvault
 */
public enum class KeySource(
    public val javaValue: com.pulumi.azurenative.storage.enums.KeySource,
) : ConvertibleToJava<com.pulumi.azurenative.storage.enums.KeySource> {
    Microsoft_Storage(com.pulumi.azurenative.storage.enums.KeySource.Microsoft_Storage),
    Microsoft_Keyvault(com.pulumi.azurenative.storage.enums.KeySource.Microsoft_Keyvault),
    ;

    override fun toJava(): com.pulumi.azurenative.storage.enums.KeySource = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.enums.KeySource): KeySource =
            KeySource.values().first { it.javaValue == javaType }
    }
}
