@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Allow or disallow public network access to Storage Account. Value is optional but if passed in, must be 'Enabled' or 'Disabled'.
 */
public enum class PublicNetworkAccess(
    public val javaValue: com.pulumi.azurenative.storage.enums.PublicNetworkAccess,
) : ConvertibleToJava<com.pulumi.azurenative.storage.enums.PublicNetworkAccess> {
    Enabled(com.pulumi.azurenative.storage.enums.PublicNetworkAccess.Enabled),
    Disabled(com.pulumi.azurenative.storage.enums.PublicNetworkAccess.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.storage.enums.PublicNetworkAccess = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.enums.PublicNetworkAccess):
            PublicNetworkAccess = PublicNetworkAccess.values().first { it.javaValue == javaType }
    }
}
