@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.AccessPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expiryTime Expiry time of the access policy
 * @property permission List of abbreviated permissions.
 * @property startTime Start time of the access policy
 */
public data class AccessPolicyArgs(
    public val expiryTime: Output<String>? = null,
    public val permission: Output<String>? = null,
    public val startTime: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.AccessPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.AccessPolicyArgs =
        com.pulumi.azurenative.storage.inputs.AccessPolicyArgs.builder()
            .expiryTime(expiryTime?.applyValue({ args0 -> args0 }))
            .permission(permission?.applyValue({ args0 -> args0 }))
            .startTime(startTime?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccessPolicyArgs].
 */
@PulumiTagMarker
public class AccessPolicyArgsBuilder internal constructor() {
    private var expiryTime: Output<String>? = null

    private var permission: Output<String>? = null

    private var startTime: Output<String>? = null

    /**
     * @param value Expiry time of the access policy
     */
    @JvmName("bdlduawktybjdhnt")
    public suspend fun expiryTime(`value`: Output<String>) {
        this.expiryTime = value
    }

    /**
     * @param value List of abbreviated permissions.
     */
    @JvmName("gubwgsrpgfjcwqhx")
    public suspend fun permission(`value`: Output<String>) {
        this.permission = value
    }

    /**
     * @param value Start time of the access policy
     */
    @JvmName("ipipbwtjabqcjtfp")
    public suspend fun startTime(`value`: Output<String>) {
        this.startTime = value
    }

    /**
     * @param value Expiry time of the access policy
     */
    @JvmName("lohxshajlvlfelni")
    public suspend fun expiryTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expiryTime = mapped
    }

    /**
     * @param value List of abbreviated permissions.
     */
    @JvmName("gfsholnsjpedacbk")
    public suspend fun permission(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.permission = mapped
    }

    /**
     * @param value Start time of the access policy
     */
    @JvmName("knqcyjnwmanxsetx")
    public suspend fun startTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startTime = mapped
    }

    internal fun build(): AccessPolicyArgs = AccessPolicyArgs(
        expiryTime = expiryTime,
        permission = permission,
        startTime = startTime,
    )
}
