@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.AzureFilesIdentityBasedAuthenticationArgs.builder
import com.pulumi.azurenative.storage.kotlin.enums.DefaultSharePermission
import com.pulumi.azurenative.storage.kotlin.enums.DirectoryServiceOptions
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Settings for Azure Files identity based authentication.
 * @property activeDirectoryProperties Required if directoryServiceOptions are AD, optional if they are AADKERB.
 * @property defaultSharePermission Default share permission for users using Kerberos authentication if RBAC role is not assigned.
 * @property directoryServiceOptions Indicates the directory service used. Note that this enum may be extended in the future.
 */
public data class AzureFilesIdentityBasedAuthenticationArgs(
    public val activeDirectoryProperties: Output<ActiveDirectoryPropertiesArgs>? = null,
    public val defaultSharePermission: Output<Either<String, DefaultSharePermission>>? = null,
    public val directoryServiceOptions: Output<Either<String, DirectoryServiceOptions>>,
) :
    ConvertibleToJava<com.pulumi.azurenative.storage.inputs.AzureFilesIdentityBasedAuthenticationArgs> {
    override fun toJava():
        com.pulumi.azurenative.storage.inputs.AzureFilesIdentityBasedAuthenticationArgs =
        com.pulumi.azurenative.storage.inputs.AzureFilesIdentityBasedAuthenticationArgs.builder()
            .activeDirectoryProperties(
                activeDirectoryProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .defaultSharePermission(
                defaultSharePermission?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .directoryServiceOptions(
                directoryServiceOptions.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [AzureFilesIdentityBasedAuthenticationArgs].
 */
@PulumiTagMarker
public class AzureFilesIdentityBasedAuthenticationArgsBuilder internal constructor() {
    private var activeDirectoryProperties: Output<ActiveDirectoryPropertiesArgs>? = null

    private var defaultSharePermission: Output<Either<String, DefaultSharePermission>>? = null

    private var directoryServiceOptions: Output<Either<String, DirectoryServiceOptions>>? = null

    /**
     * @param value Required if directoryServiceOptions are AD, optional if they are AADKERB.
     */
    @JvmName("udygvsyaalqeejyc")
    public suspend fun activeDirectoryProperties(`value`: Output<ActiveDirectoryPropertiesArgs>) {
        this.activeDirectoryProperties = value
    }

    /**
     * @param value Default share permission for users using Kerberos authentication if RBAC role is not assigned.
     */
    @JvmName("nkrxqnkmdpeddvse")
    public suspend
    fun defaultSharePermission(`value`: Output<Either<String, DefaultSharePermission>>) {
        this.defaultSharePermission = value
    }

    /**
     * @param value Indicates the directory service used. Note that this enum may be extended in the future.
     */
    @JvmName("mksqqyehfsupmbvy")
    public suspend
    fun directoryServiceOptions(`value`: Output<Either<String, DirectoryServiceOptions>>) {
        this.directoryServiceOptions = value
    }

    /**
     * @param value Required if directoryServiceOptions are AD, optional if they are AADKERB.
     */
    @JvmName("wsglpojsihvhstqy")
    public suspend fun activeDirectoryProperties(`value`: ActiveDirectoryPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.activeDirectoryProperties = mapped
    }

    /**
     * @param argument Required if directoryServiceOptions are AD, optional if they are AADKERB.
     */
    @JvmName("cnlfmwpnyuyfnvpn")
    public suspend
    fun activeDirectoryProperties(argument: suspend ActiveDirectoryPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ActiveDirectoryPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.activeDirectoryProperties = mapped
    }

    /**
     * @param value Default share permission for users using Kerberos authentication if RBAC role is not assigned.
     */
    @JvmName("tiknnlpugvsqsnsk")
    public suspend fun defaultSharePermission(`value`: Either<String, DefaultSharePermission>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultSharePermission = mapped
    }

    /**
     * @param value Default share permission for users using Kerberos authentication if RBAC role is not assigned.
     */
    @JvmName("wrylnddwwkwrbeyx")
    public fun defaultSharePermission(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DefaultSharePermission>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultSharePermission = mapped
    }

    /**
     * @param value Default share permission for users using Kerberos authentication if RBAC role is not assigned.
     */
    @JvmName("apfanrptuocvakwr")
    public fun defaultSharePermission(`value`: DefaultSharePermission) {
        val toBeMapped = Either.ofRight<String, DefaultSharePermission>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultSharePermission = mapped
    }

    /**
     * @param value Indicates the directory service used. Note that this enum may be extended in the future.
     */
    @JvmName("gdtygfrxkmpttogo")
    public suspend fun directoryServiceOptions(`value`: Either<String, DirectoryServiceOptions>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.directoryServiceOptions = mapped
    }

    /**
     * @param value Indicates the directory service used. Note that this enum may be extended in the future.
     */
    @JvmName("dhqwtukxkpbjkgag")
    public fun directoryServiceOptions(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DirectoryServiceOptions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.directoryServiceOptions = mapped
    }

    /**
     * @param value Indicates the directory service used. Note that this enum may be extended in the future.
     */
    @JvmName("vqvcgiyntepqnhly")
    public fun directoryServiceOptions(`value`: DirectoryServiceOptions) {
        val toBeMapped = Either.ofRight<String, DirectoryServiceOptions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.directoryServiceOptions = mapped
    }

    internal fun build(): AzureFilesIdentityBasedAuthenticationArgs =
        AzureFilesIdentityBasedAuthenticationArgs(
            activeDirectoryProperties = activeDirectoryProperties,
            defaultSharePermission = defaultSharePermission,
            directoryServiceOptions = directoryServiceOptions ?: throw
                PulumiNullFieldException("directoryServiceOptions"),
        )
}
