@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.DateAfterCreationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Object to define snapshot and version action conditions.
 * @property daysAfterCreationGreaterThan Value indicating the age in days after creation
 * @property daysAfterLastTierChangeGreaterThan Value indicating the age in days after last blob tier change time. This property is only applicable for tierToArchive actions and requires daysAfterCreationGreaterThan to be set for snapshots and blob version based actions. The blob will be archived if both the conditions are satisfied.
 */
public data class DateAfterCreationArgs(
    public val daysAfterCreationGreaterThan: Output<Double>,
    public val daysAfterLastTierChangeGreaterThan: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.DateAfterCreationArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.DateAfterCreationArgs =
        com.pulumi.azurenative.storage.inputs.DateAfterCreationArgs.builder()
            .daysAfterCreationGreaterThan(daysAfterCreationGreaterThan.applyValue({ args0 -> args0 }))
            .daysAfterLastTierChangeGreaterThan(
                daysAfterLastTierChangeGreaterThan?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [DateAfterCreationArgs].
 */
@PulumiTagMarker
public class DateAfterCreationArgsBuilder internal constructor() {
    private var daysAfterCreationGreaterThan: Output<Double>? = null

    private var daysAfterLastTierChangeGreaterThan: Output<Double>? = null

    /**
     * @param value Value indicating the age in days after creation
     */
    @JvmName("edvsblkurcwsdixd")
    public suspend fun daysAfterCreationGreaterThan(`value`: Output<Double>) {
        this.daysAfterCreationGreaterThan = value
    }

    /**
     * @param value Value indicating the age in days after last blob tier change time. This property is only applicable for tierToArchive actions and requires daysAfterCreationGreaterThan to be set for snapshots and blob version based actions. The blob will be archived if both the conditions are satisfied.
     */
    @JvmName("rloffjutaoensssx")
    public suspend fun daysAfterLastTierChangeGreaterThan(`value`: Output<Double>) {
        this.daysAfterLastTierChangeGreaterThan = value
    }

    /**
     * @param value Value indicating the age in days after creation
     */
    @JvmName("umaprmhnsbfeneqk")
    public suspend fun daysAfterCreationGreaterThan(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.daysAfterCreationGreaterThan = mapped
    }

    /**
     * @param value Value indicating the age in days after last blob tier change time. This property is only applicable for tierToArchive actions and requires daysAfterCreationGreaterThan to be set for snapshots and blob version based actions. The blob will be archived if both the conditions are satisfied.
     */
    @JvmName("rfwnsbsxvuuvcegk")
    public suspend fun daysAfterLastTierChangeGreaterThan(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.daysAfterLastTierChangeGreaterThan = mapped
    }

    internal fun build(): DateAfterCreationArgs = DateAfterCreationArgs(
        daysAfterCreationGreaterThan = daysAfterCreationGreaterThan ?: throw
            PulumiNullFieldException("daysAfterCreationGreaterThan"),
        daysAfterLastTierChangeGreaterThan = daysAfterLastTierChangeGreaterThan,
    )
}
