@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.DateAfterModificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Object to define the base blob action conditions. Properties daysAfterModificationGreaterThan, daysAfterLastAccessTimeGreaterThan and daysAfterCreationGreaterThan are mutually exclusive. The daysAfterLastTierChangeGreaterThan property is only applicable for tierToArchive actions which requires daysAfterModificationGreaterThan to be set, also it cannot be used in conjunction with daysAfterLastAccessTimeGreaterThan or daysAfterCreationGreaterThan.
 * @property daysAfterCreationGreaterThan Value indicating the age in days after blob creation.
 * @property daysAfterLastAccessTimeGreaterThan Value indicating the age in days after last blob access. This property can only be used in conjunction with last access time tracking policy
 * @property daysAfterLastTierChangeGreaterThan Value indicating the age in days after last blob tier change time. This property is only applicable for tierToArchive actions and requires daysAfterModificationGreaterThan to be set for baseBlobs based actions. The blob will be archived if both the conditions are satisfied.
 * @property daysAfterModificationGreaterThan Value indicating the age in days after last modification
 */
public data class DateAfterModificationArgs(
    public val daysAfterCreationGreaterThan: Output<Double>? = null,
    public val daysAfterLastAccessTimeGreaterThan: Output<Double>? = null,
    public val daysAfterLastTierChangeGreaterThan: Output<Double>? = null,
    public val daysAfterModificationGreaterThan: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.DateAfterModificationArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.DateAfterModificationArgs =
        com.pulumi.azurenative.storage.inputs.DateAfterModificationArgs.builder()
            .daysAfterCreationGreaterThan(daysAfterCreationGreaterThan?.applyValue({ args0 -> args0 }))
            .daysAfterLastAccessTimeGreaterThan(
                daysAfterLastAccessTimeGreaterThan?.applyValue({ args0 ->
                    args0
                }),
            )
            .daysAfterLastTierChangeGreaterThan(
                daysAfterLastTierChangeGreaterThan?.applyValue({ args0 ->
                    args0
                }),
            )
            .daysAfterModificationGreaterThan(
                daysAfterModificationGreaterThan?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [DateAfterModificationArgs].
 */
@PulumiTagMarker
public class DateAfterModificationArgsBuilder internal constructor() {
    private var daysAfterCreationGreaterThan: Output<Double>? = null

    private var daysAfterLastAccessTimeGreaterThan: Output<Double>? = null

    private var daysAfterLastTierChangeGreaterThan: Output<Double>? = null

    private var daysAfterModificationGreaterThan: Output<Double>? = null

    /**
     * @param value Value indicating the age in days after blob creation.
     */
    @JvmName("ukgailbpqwhdrxue")
    public suspend fun daysAfterCreationGreaterThan(`value`: Output<Double>) {
        this.daysAfterCreationGreaterThan = value
    }

    /**
     * @param value Value indicating the age in days after last blob access. This property can only be used in conjunction with last access time tracking policy
     */
    @JvmName("gxsxkoracwxfdfpq")
    public suspend fun daysAfterLastAccessTimeGreaterThan(`value`: Output<Double>) {
        this.daysAfterLastAccessTimeGreaterThan = value
    }

    /**
     * @param value Value indicating the age in days after last blob tier change time. This property is only applicable for tierToArchive actions and requires daysAfterModificationGreaterThan to be set for baseBlobs based actions. The blob will be archived if both the conditions are satisfied.
     */
    @JvmName("vpepiqxmyoxhgqbt")
    public suspend fun daysAfterLastTierChangeGreaterThan(`value`: Output<Double>) {
        this.daysAfterLastTierChangeGreaterThan = value
    }

    /**
     * @param value Value indicating the age in days after last modification
     */
    @JvmName("ovhdgwyiiomakien")
    public suspend fun daysAfterModificationGreaterThan(`value`: Output<Double>) {
        this.daysAfterModificationGreaterThan = value
    }

    /**
     * @param value Value indicating the age in days after blob creation.
     */
    @JvmName("qyyixclhtvytpbqu")
    public suspend fun daysAfterCreationGreaterThan(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.daysAfterCreationGreaterThan = mapped
    }

    /**
     * @param value Value indicating the age in days after last blob access. This property can only be used in conjunction with last access time tracking policy
     */
    @JvmName("lepjubeagmdgwikq")
    public suspend fun daysAfterLastAccessTimeGreaterThan(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.daysAfterLastAccessTimeGreaterThan = mapped
    }

    /**
     * @param value Value indicating the age in days after last blob tier change time. This property is only applicable for tierToArchive actions and requires daysAfterModificationGreaterThan to be set for baseBlobs based actions. The blob will be archived if both the conditions are satisfied.
     */
    @JvmName("lkxkxqnregldvndn")
    public suspend fun daysAfterLastTierChangeGreaterThan(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.daysAfterLastTierChangeGreaterThan = mapped
    }

    /**
     * @param value Value indicating the age in days after last modification
     */
    @JvmName("gplxwblvinrvtjtx")
    public suspend fun daysAfterModificationGreaterThan(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.daysAfterModificationGreaterThan = mapped
    }

    internal fun build(): DateAfterModificationArgs = DateAfterModificationArgs(
        daysAfterCreationGreaterThan = daysAfterCreationGreaterThan,
        daysAfterLastAccessTimeGreaterThan = daysAfterLastAccessTimeGreaterThan,
        daysAfterLastTierChangeGreaterThan = daysAfterLastTierChangeGreaterThan,
        daysAfterModificationGreaterThan = daysAfterModificationGreaterThan,
    )
}
