@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.DeleteRetentionPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The service properties for soft delete.
 * @property allowPermanentDelete This property when set to true allows deletion of the soft deleted blob versions and snapshots. This property cannot be used blob restore policy. This property only applies to blob service and does not apply to containers or file share.
 * @property days Indicates the number of days that the deleted item should be retained. The minimum specified value can be 1 and the maximum value can be 365.
 * @property enabled Indicates whether DeleteRetentionPolicy is enabled.
 */
public data class DeleteRetentionPolicyArgs(
    public val allowPermanentDelete: Output<Boolean>? = null,
    public val days: Output<Int>? = null,
    public val enabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.DeleteRetentionPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.DeleteRetentionPolicyArgs =
        com.pulumi.azurenative.storage.inputs.DeleteRetentionPolicyArgs.builder()
            .allowPermanentDelete(allowPermanentDelete?.applyValue({ args0 -> args0 }))
            .days(days?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DeleteRetentionPolicyArgs].
 */
@PulumiTagMarker
public class DeleteRetentionPolicyArgsBuilder internal constructor() {
    private var allowPermanentDelete: Output<Boolean>? = null

    private var days: Output<Int>? = null

    private var enabled: Output<Boolean>? = null

    /**
     * @param value This property when set to true allows deletion of the soft deleted blob versions and snapshots. This property cannot be used blob restore policy. This property only applies to blob service and does not apply to containers or file share.
     */
    @JvmName("gdtseerblkaiciom")
    public suspend fun allowPermanentDelete(`value`: Output<Boolean>) {
        this.allowPermanentDelete = value
    }

    /**
     * @param value Indicates the number of days that the deleted item should be retained. The minimum specified value can be 1 and the maximum value can be 365.
     */
    @JvmName("gudrqaroyntwtuqe")
    public suspend fun days(`value`: Output<Int>) {
        this.days = value
    }

    /**
     * @param value Indicates whether DeleteRetentionPolicy is enabled.
     */
    @JvmName("nbhpsqktfnauucqi")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value This property when set to true allows deletion of the soft deleted blob versions and snapshots. This property cannot be used blob restore policy. This property only applies to blob service and does not apply to containers or file share.
     */
    @JvmName("emlesopihbvwhuqk")
    public suspend fun allowPermanentDelete(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowPermanentDelete = mapped
    }

    /**
     * @param value Indicates the number of days that the deleted item should be retained. The minimum specified value can be 1 and the maximum value can be 365.
     */
    @JvmName("fhmxmiakbqfjkukk")
    public suspend fun days(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.days = mapped
    }

    /**
     * @param value Indicates whether DeleteRetentionPolicy is enabled.
     */
    @JvmName("bkdiyipibraehumm")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): DeleteRetentionPolicyArgs = DeleteRetentionPolicyArgs(
        allowPermanentDelete = allowPermanentDelete,
        days = days,
        enabled = enabled,
    )
}
