@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.GetObjectReplicationPolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
 * @property objectReplicationPolicyId For the destination account, provide the value 'default'. Configure the policy on the destination account first. For the source account, provide the value of the policy ID that is returned when you download the policy that was defined on the destination account. The policy is downloaded as a JSON file.
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 */
public data class GetObjectReplicationPolicyPlainArgs(
    public val accountName: String,
    public val objectReplicationPolicyId: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.GetObjectReplicationPolicyPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.GetObjectReplicationPolicyPlainArgs =
        com.pulumi.azurenative.storage.inputs.GetObjectReplicationPolicyPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .objectReplicationPolicyId(objectReplicationPolicyId.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetObjectReplicationPolicyPlainArgs].
 */
@PulumiTagMarker
public class GetObjectReplicationPolicyPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var objectReplicationPolicyId: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("jifcdjoabmfxidvl")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value For the destination account, provide the value 'default'. Configure the policy on the destination account first. For the source account, provide the value of the policy ID that is returned when you download the policy that was defined on the destination account. The policy is downloaded as a JSON file.
     */
    @JvmName("myivsjtpvhgdwvra")
    public suspend fun objectReplicationPolicyId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.objectReplicationPolicyId = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("wqwqkdpjjateqyhq")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetObjectReplicationPolicyPlainArgs = GetObjectReplicationPolicyPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        objectReplicationPolicyId = objectReplicationPolicyId ?: throw
            PulumiNullFieldException("objectReplicationPolicyId"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
