@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.ListStorageAccountServiceSASPlainArgs.builder
import com.pulumi.azurenative.storage.kotlin.enums.HttpProtocol
import com.pulumi.azurenative.storage.kotlin.enums.Permissions
import com.pulumi.azurenative.storage.kotlin.enums.SignedResource
import com.pulumi.core.Either
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
 * @property cacheControl The response header override for cache control.
 * @property canonicalizedResource The canonical path to the signed resource.
 * @property contentDisposition The response header override for content disposition.
 * @property contentEncoding The response header override for content encoding.
 * @property contentLanguage The response header override for content language.
 * @property contentType The response header override for content type.
 * @property iPAddressOrRange An IP address or a range of IP addresses from which to accept requests.
 * @property identifier A unique value up to 64 characters in length that correlates to an access policy specified for the container, queue, or table.
 * @property keyToSign The key to sign the account SAS token with.
 * @property partitionKeyEnd The end of partition key.
 * @property partitionKeyStart The start of partition key.
 * @property permissions The signed permissions for the service SAS. Possible values include: Read (r), Write (w), Delete (d), List (l), Add (a), Create (c), Update (u) and Process (p).
 * @property protocols The protocol permitted for a request made with the account SAS.
 * @property resource The signed services accessible with the service SAS. Possible values include: Blob (b), Container (c), File (f), Share (s).
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 * @property rowKeyEnd The end of row key.
 * @property rowKeyStart The start of row key.
 * @property sharedAccessExpiryTime The time at which the shared access signature becomes invalid.
 * @property sharedAccessStartTime The time at which the SAS becomes valid.
 */
public data class ListStorageAccountServiceSASPlainArgs(
    public val accountName: String,
    public val cacheControl: String? = null,
    public val canonicalizedResource: String,
    public val contentDisposition: String? = null,
    public val contentEncoding: String? = null,
    public val contentLanguage: String? = null,
    public val contentType: String? = null,
    public val iPAddressOrRange: String? = null,
    public val identifier: String? = null,
    public val keyToSign: String? = null,
    public val partitionKeyEnd: String? = null,
    public val partitionKeyStart: String? = null,
    public val permissions: Either<String, Permissions>? = null,
    public val protocols: HttpProtocol? = null,
    public val resource: Either<String, SignedResource>? = null,
    public val resourceGroupName: String,
    public val rowKeyEnd: String? = null,
    public val rowKeyStart: String? = null,
    public val sharedAccessExpiryTime: String? = null,
    public val sharedAccessStartTime: String? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.ListStorageAccountServiceSASPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.ListStorageAccountServiceSASPlainArgs =
        com.pulumi.azurenative.storage.inputs.ListStorageAccountServiceSASPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .cacheControl(cacheControl?.let({ args0 -> args0 }))
            .canonicalizedResource(canonicalizedResource.let({ args0 -> args0 }))
            .contentDisposition(contentDisposition?.let({ args0 -> args0 }))
            .contentEncoding(contentEncoding?.let({ args0 -> args0 }))
            .contentLanguage(contentLanguage?.let({ args0 -> args0 }))
            .contentType(contentType?.let({ args0 -> args0 }))
            .iPAddressOrRange(iPAddressOrRange?.let({ args0 -> args0 }))
            .identifier(identifier?.let({ args0 -> args0 }))
            .keyToSign(keyToSign?.let({ args0 -> args0 }))
            .partitionKeyEnd(partitionKeyEnd?.let({ args0 -> args0 }))
            .partitionKeyStart(partitionKeyStart?.let({ args0 -> args0 }))
            .permissions(
                permissions?.let({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .protocols(protocols?.let({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resource(
                resource?.let({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .rowKeyEnd(rowKeyEnd?.let({ args0 -> args0 }))
            .rowKeyStart(rowKeyStart?.let({ args0 -> args0 }))
            .sharedAccessExpiryTime(sharedAccessExpiryTime?.let({ args0 -> args0 }))
            .sharedAccessStartTime(sharedAccessStartTime?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListStorageAccountServiceSASPlainArgs].
 */
@PulumiTagMarker
public class ListStorageAccountServiceSASPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var cacheControl: String? = null

    private var canonicalizedResource: String? = null

    private var contentDisposition: String? = null

    private var contentEncoding: String? = null

    private var contentLanguage: String? = null

    private var contentType: String? = null

    private var iPAddressOrRange: String? = null

    private var identifier: String? = null

    private var keyToSign: String? = null

    private var partitionKeyEnd: String? = null

    private var partitionKeyStart: String? = null

    private var permissions: Either<String, Permissions>? = null

    private var protocols: HttpProtocol? = null

    private var resource: Either<String, SignedResource>? = null

    private var resourceGroupName: String? = null

    private var rowKeyEnd: String? = null

    private var rowKeyStart: String? = null

    private var sharedAccessExpiryTime: String? = null

    private var sharedAccessStartTime: String? = null

    /**
     * @param value The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("qlgpjahvqlbndshp")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The response header override for cache control.
     */
    @JvmName("jnpokjwgqdbmgotp")
    public suspend fun cacheControl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.cacheControl = mapped
    }

    /**
     * @param value The canonical path to the signed resource.
     */
    @JvmName("sydnkgppilibwsmt")
    public suspend fun canonicalizedResource(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.canonicalizedResource = mapped
    }

    /**
     * @param value The response header override for content disposition.
     */
    @JvmName("ftasyovdvvrlkvdd")
    public suspend fun contentDisposition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.contentDisposition = mapped
    }

    /**
     * @param value The response header override for content encoding.
     */
    @JvmName("meajdiyubyvrtsaf")
    public suspend fun contentEncoding(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.contentEncoding = mapped
    }

    /**
     * @param value The response header override for content language.
     */
    @JvmName("riiankhhpmglhxds")
    public suspend fun contentLanguage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.contentLanguage = mapped
    }

    /**
     * @param value The response header override for content type.
     */
    @JvmName("gmknincorhafgycu")
    public suspend fun contentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.contentType = mapped
    }

    /**
     * @param value An IP address or a range of IP addresses from which to accept requests.
     */
    @JvmName("iobclincdrdubyxa")
    public suspend fun iPAddressOrRange(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.iPAddressOrRange = mapped
    }

    /**
     * @param value A unique value up to 64 characters in length that correlates to an access policy specified for the container, queue, or table.
     */
    @JvmName("rglrtteglgakconm")
    public suspend fun identifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.identifier = mapped
    }

    /**
     * @param value The key to sign the account SAS token with.
     */
    @JvmName("hyieyaowexeantwt")
    public suspend fun keyToSign(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.keyToSign = mapped
    }

    /**
     * @param value The end of partition key.
     */
    @JvmName("wvycbdylfvxeexch")
    public suspend fun partitionKeyEnd(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.partitionKeyEnd = mapped
    }

    /**
     * @param value The start of partition key.
     */
    @JvmName("tgiwqfuetydlvnkb")
    public suspend fun partitionKeyStart(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.partitionKeyStart = mapped
    }

    /**
     * @param value The signed permissions for the service SAS. Possible values include: Read (r), Write (w), Delete (d), List (l), Add (a), Create (c), Update (u) and Process (p).
     */
    @JvmName("ddgfvmivjjyfpbtl")
    public suspend fun permissions(`value`: Either<String, Permissions>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.permissions = mapped
    }

    /**
     * @param value The signed permissions for the service SAS. Possible values include: Read (r), Write (w), Delete (d), List (l), Add (a), Create (c), Update (u) and Process (p).
     */
    @JvmName("qqrxbhctlvnwndro")
    public fun permissions(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Permissions>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.permissions = mapped
    }

    /**
     * @param value The signed permissions for the service SAS. Possible values include: Read (r), Write (w), Delete (d), List (l), Add (a), Create (c), Update (u) and Process (p).
     */
    @JvmName("xttmqiqpoiffrqwd")
    public fun permissions(`value`: Permissions) {
        val toBeMapped = Either.ofRight<String, Permissions>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.permissions = mapped
    }

    /**
     * @param value The protocol permitted for a request made with the account SAS.
     */
    @JvmName("mybgutthkyhnyycd")
    public suspend fun protocols(`value`: HttpProtocol?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.protocols = mapped
    }

    /**
     * @param value The signed services accessible with the service SAS. Possible values include: Blob (b), Container (c), File (f), Share (s).
     */
    @JvmName("liaymcerudlcvdxt")
    public suspend fun resource(`value`: Either<String, SignedResource>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resource = mapped
    }

    /**
     * @param value The signed services accessible with the service SAS. Possible values include: Blob (b), Container (c), File (f), Share (s).
     */
    @JvmName("wcdpnnynmbuhgkuc")
    public fun resource(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SignedResource>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resource = mapped
    }

    /**
     * @param value The signed services accessible with the service SAS. Possible values include: Blob (b), Container (c), File (f), Share (s).
     */
    @JvmName("fqvrqmcdjognwnxj")
    public fun resource(`value`: SignedResource) {
        val toBeMapped = Either.ofRight<String, SignedResource>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resource = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("yypfffljiuxxscah")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The end of row key.
     */
    @JvmName("sskoqebktrujnmbf")
    public suspend fun rowKeyEnd(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.rowKeyEnd = mapped
    }

    /**
     * @param value The start of row key.
     */
    @JvmName("hhkeuxcwuudnlkei")
    public suspend fun rowKeyStart(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.rowKeyStart = mapped
    }

    /**
     * @param value The time at which the shared access signature becomes invalid.
     */
    @JvmName("yjqnjsvhvdcckech")
    public suspend fun sharedAccessExpiryTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sharedAccessExpiryTime = mapped
    }

    /**
     * @param value The time at which the SAS becomes valid.
     */
    @JvmName("crulikrvteftedny")
    public suspend fun sharedAccessStartTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sharedAccessStartTime = mapped
    }

    internal fun build(): ListStorageAccountServiceSASPlainArgs =
        ListStorageAccountServiceSASPlainArgs(
            accountName = accountName ?: throw PulumiNullFieldException("accountName"),
            cacheControl = cacheControl,
            canonicalizedResource = canonicalizedResource ?: throw
                PulumiNullFieldException("canonicalizedResource"),
            contentDisposition = contentDisposition,
            contentEncoding = contentEncoding,
            contentLanguage = contentLanguage,
            contentType = contentType,
            iPAddressOrRange = iPAddressOrRange,
            identifier = identifier,
            keyToSign = keyToSign,
            partitionKeyEnd = partitionKeyEnd,
            partitionKeyStart = partitionKeyStart,
            permissions = permissions,
            protocols = protocols,
            resource = resource,
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            rowKeyEnd = rowKeyEnd,
            rowKeyStart = rowKeyStart,
            sharedAccessExpiryTime = sharedAccessExpiryTime,
            sharedAccessStartTime = sharedAccessStartTime,
        )
}
