@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.ManagementPolicyBaseBlobArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Management policy action for base blob.
 * @property delete The function to delete the blob
 * @property enableAutoTierToHotFromCool This property enables auto tiering of a blob from cool to hot on a blob access. This property requires tierToCool.daysAfterLastAccessTimeGreaterThan.
 * @property tierToArchive The function to tier blobs to archive storage.
 * @property tierToCold The function to tier blobs to cold storage.
 * @property tierToCool The function to tier blobs to cool storage.
 * @property tierToHot The function to tier blobs to hot storage. This action can only be used with Premium Block Blob Storage Accounts
 */
public data class ManagementPolicyBaseBlobArgs(
    public val delete: Output<DateAfterModificationArgs>? = null,
    public val enableAutoTierToHotFromCool: Output<Boolean>? = null,
    public val tierToArchive: Output<DateAfterModificationArgs>? = null,
    public val tierToCold: Output<DateAfterModificationArgs>? = null,
    public val tierToCool: Output<DateAfterModificationArgs>? = null,
    public val tierToHot: Output<DateAfterModificationArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.ManagementPolicyBaseBlobArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.ManagementPolicyBaseBlobArgs =
        com.pulumi.azurenative.storage.inputs.ManagementPolicyBaseBlobArgs.builder()
            .delete(delete?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enableAutoTierToHotFromCool(enableAutoTierToHotFromCool?.applyValue({ args0 -> args0 }))
            .tierToArchive(tierToArchive?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tierToCold(tierToCold?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tierToCool(tierToCool?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tierToHot(tierToHot?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ManagementPolicyBaseBlobArgs].
 */
@PulumiTagMarker
public class ManagementPolicyBaseBlobArgsBuilder internal constructor() {
    private var delete: Output<DateAfterModificationArgs>? = null

    private var enableAutoTierToHotFromCool: Output<Boolean>? = null

    private var tierToArchive: Output<DateAfterModificationArgs>? = null

    private var tierToCold: Output<DateAfterModificationArgs>? = null

    private var tierToCool: Output<DateAfterModificationArgs>? = null

    private var tierToHot: Output<DateAfterModificationArgs>? = null

    /**
     * @param value The function to delete the blob
     */
    @JvmName("jhvccxgdgtobmuyj")
    public suspend fun delete(`value`: Output<DateAfterModificationArgs>) {
        this.delete = value
    }

    /**
     * @param value This property enables auto tiering of a blob from cool to hot on a blob access. This property requires tierToCool.daysAfterLastAccessTimeGreaterThan.
     */
    @JvmName("tjggawahfjbwqile")
    public suspend fun enableAutoTierToHotFromCool(`value`: Output<Boolean>) {
        this.enableAutoTierToHotFromCool = value
    }

    /**
     * @param value The function to tier blobs to archive storage.
     */
    @JvmName("acxpqwdjarxritoh")
    public suspend fun tierToArchive(`value`: Output<DateAfterModificationArgs>) {
        this.tierToArchive = value
    }

    /**
     * @param value The function to tier blobs to cold storage.
     */
    @JvmName("ovahpaohmwoglmoe")
    public suspend fun tierToCold(`value`: Output<DateAfterModificationArgs>) {
        this.tierToCold = value
    }

    /**
     * @param value The function to tier blobs to cool storage.
     */
    @JvmName("drmqvwjjxmackytr")
    public suspend fun tierToCool(`value`: Output<DateAfterModificationArgs>) {
        this.tierToCool = value
    }

    /**
     * @param value The function to tier blobs to hot storage. This action can only be used with Premium Block Blob Storage Accounts
     */
    @JvmName("nbdbqailcjegfbtp")
    public suspend fun tierToHot(`value`: Output<DateAfterModificationArgs>) {
        this.tierToHot = value
    }

    /**
     * @param value The function to delete the blob
     */
    @JvmName("nnmgwdpgttgjbjki")
    public suspend fun delete(`value`: DateAfterModificationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.delete = mapped
    }

    /**
     * @param argument The function to delete the blob
     */
    @JvmName("gsdvkoaicqdofhxo")
    public suspend fun delete(argument: suspend DateAfterModificationArgsBuilder.() -> Unit) {
        val toBeMapped = DateAfterModificationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.delete = mapped
    }

    /**
     * @param value This property enables auto tiering of a blob from cool to hot on a blob access. This property requires tierToCool.daysAfterLastAccessTimeGreaterThan.
     */
    @JvmName("ivihbmcankucouqf")
    public suspend fun enableAutoTierToHotFromCool(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableAutoTierToHotFromCool = mapped
    }

    /**
     * @param value The function to tier blobs to archive storage.
     */
    @JvmName("enmelljnhsimfmrw")
    public suspend fun tierToArchive(`value`: DateAfterModificationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tierToArchive = mapped
    }

    /**
     * @param argument The function to tier blobs to archive storage.
     */
    @JvmName("kncexagnidxjthmn")
    public suspend fun tierToArchive(argument: suspend DateAfterModificationArgsBuilder.() -> Unit) {
        val toBeMapped = DateAfterModificationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tierToArchive = mapped
    }

    /**
     * @param value The function to tier blobs to cold storage.
     */
    @JvmName("nnbkowytjgmyebfe")
    public suspend fun tierToCold(`value`: DateAfterModificationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tierToCold = mapped
    }

    /**
     * @param argument The function to tier blobs to cold storage.
     */
    @JvmName("hylgafeckstduvdx")
    public suspend fun tierToCold(argument: suspend DateAfterModificationArgsBuilder.() -> Unit) {
        val toBeMapped = DateAfterModificationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tierToCold = mapped
    }

    /**
     * @param value The function to tier blobs to cool storage.
     */
    @JvmName("vgqjdeqlueqqohak")
    public suspend fun tierToCool(`value`: DateAfterModificationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tierToCool = mapped
    }

    /**
     * @param argument The function to tier blobs to cool storage.
     */
    @JvmName("kslvaestduhwmngk")
    public suspend fun tierToCool(argument: suspend DateAfterModificationArgsBuilder.() -> Unit) {
        val toBeMapped = DateAfterModificationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tierToCool = mapped
    }

    /**
     * @param value The function to tier blobs to hot storage. This action can only be used with Premium Block Blob Storage Accounts
     */
    @JvmName("chmqonsaepwiluvd")
    public suspend fun tierToHot(`value`: DateAfterModificationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tierToHot = mapped
    }

    /**
     * @param argument The function to tier blobs to hot storage. This action can only be used with Premium Block Blob Storage Accounts
     */
    @JvmName("hqpcfbkmytgywbns")
    public suspend fun tierToHot(argument: suspend DateAfterModificationArgsBuilder.() -> Unit) {
        val toBeMapped = DateAfterModificationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tierToHot = mapped
    }

    internal fun build(): ManagementPolicyBaseBlobArgs = ManagementPolicyBaseBlobArgs(
        delete = delete,
        enableAutoTierToHotFromCool = enableAutoTierToHotFromCool,
        tierToArchive = tierToArchive,
        tierToCold = tierToCold,
        tierToCool = tierToCool,
        tierToHot = tierToHot,
    )
}
