@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.ManagementPolicyDefinitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * An object that defines the Lifecycle rule. Each definition is made up with a filters set and an actions set.
 * @property actions An object that defines the action set.
 * @property filters An object that defines the filter set.
 */
public data class ManagementPolicyDefinitionArgs(
    public val actions: Output<ManagementPolicyActionArgs>,
    public val filters: Output<ManagementPolicyFilterArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.ManagementPolicyDefinitionArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.ManagementPolicyDefinitionArgs =
        com.pulumi.azurenative.storage.inputs.ManagementPolicyDefinitionArgs.builder()
            .actions(actions.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .filters(filters?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ManagementPolicyDefinitionArgs].
 */
@PulumiTagMarker
public class ManagementPolicyDefinitionArgsBuilder internal constructor() {
    private var actions: Output<ManagementPolicyActionArgs>? = null

    private var filters: Output<ManagementPolicyFilterArgs>? = null

    /**
     * @param value An object that defines the action set.
     */
    @JvmName("ppvutmymufcibqvy")
    public suspend fun actions(`value`: Output<ManagementPolicyActionArgs>) {
        this.actions = value
    }

    /**
     * @param value An object that defines the filter set.
     */
    @JvmName("nyxcevlusmmrumky")
    public suspend fun filters(`value`: Output<ManagementPolicyFilterArgs>) {
        this.filters = value
    }

    /**
     * @param value An object that defines the action set.
     */
    @JvmName("uchcmkunbrmhxrhm")
    public suspend fun actions(`value`: ManagementPolicyActionArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param argument An object that defines the action set.
     */
    @JvmName("pbwojjxevlsjxoce")
    public suspend fun actions(argument: suspend ManagementPolicyActionArgsBuilder.() -> Unit) {
        val toBeMapped = ManagementPolicyActionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.actions = mapped
    }

    /**
     * @param value An object that defines the filter set.
     */
    @JvmName("oiodcuiluprwkvgk")
    public suspend fun filters(`value`: ManagementPolicyFilterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filters = mapped
    }

    /**
     * @param argument An object that defines the filter set.
     */
    @JvmName("byjfukxinukgirvf")
    public suspend fun filters(argument: suspend ManagementPolicyFilterArgsBuilder.() -> Unit) {
        val toBeMapped = ManagementPolicyFilterArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.filters = mapped
    }

    internal fun build(): ManagementPolicyDefinitionArgs = ManagementPolicyDefinitionArgs(
        actions = actions ?: throw PulumiNullFieldException("actions"),
        filters = filters,
    )
}
