@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.ManagementPolicyFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Filters limit rule actions to a subset of blobs within the storage account. If multiple filters are defined, a logical AND is performed on all filters.
 * @property blobIndexMatch An array of blob index tag based filters, there can be at most 10 tag filters
 * @property blobTypes An array of predefined enum values. Currently blockBlob supports all tiering and delete actions. Only delete actions are supported for appendBlob.
 * @property prefixMatch An array of strings for prefixes to be match.
 */
public data class ManagementPolicyFilterArgs(
    public val blobIndexMatch: Output<List<TagFilterArgs>>? = null,
    public val blobTypes: Output<List<String>>,
    public val prefixMatch: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.ManagementPolicyFilterArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.ManagementPolicyFilterArgs =
        com.pulumi.azurenative.storage.inputs.ManagementPolicyFilterArgs.builder()
            .blobIndexMatch(
                blobIndexMatch?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .blobTypes(blobTypes.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .prefixMatch(prefixMatch?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ManagementPolicyFilterArgs].
 */
@PulumiTagMarker
public class ManagementPolicyFilterArgsBuilder internal constructor() {
    private var blobIndexMatch: Output<List<TagFilterArgs>>? = null

    private var blobTypes: Output<List<String>>? = null

    private var prefixMatch: Output<List<String>>? = null

    /**
     * @param value An array of blob index tag based filters, there can be at most 10 tag filters
     */
    @JvmName("hkcghfhwmqgcosxs")
    public suspend fun blobIndexMatch(`value`: Output<List<TagFilterArgs>>) {
        this.blobIndexMatch = value
    }

    @JvmName("dcoweiefbilgolok")
    public suspend fun blobIndexMatch(vararg values: Output<TagFilterArgs>) {
        this.blobIndexMatch = Output.all(values.asList())
    }

    /**
     * @param values An array of blob index tag based filters, there can be at most 10 tag filters
     */
    @JvmName("xsxqjdxaaoyxxgkk")
    public suspend fun blobIndexMatch(values: List<Output<TagFilterArgs>>) {
        this.blobIndexMatch = Output.all(values)
    }

    /**
     * @param value An array of predefined enum values. Currently blockBlob supports all tiering and delete actions. Only delete actions are supported for appendBlob.
     */
    @JvmName("loptrelttkrwsmve")
    public suspend fun blobTypes(`value`: Output<List<String>>) {
        this.blobTypes = value
    }

    @JvmName("eavsjwrxpsxydern")
    public suspend fun blobTypes(vararg values: Output<String>) {
        this.blobTypes = Output.all(values.asList())
    }

    /**
     * @param values An array of predefined enum values. Currently blockBlob supports all tiering and delete actions. Only delete actions are supported for appendBlob.
     */
    @JvmName("sfdmtpnqoombtoyc")
    public suspend fun blobTypes(values: List<Output<String>>) {
        this.blobTypes = Output.all(values)
    }

    /**
     * @param value An array of strings for prefixes to be match.
     */
    @JvmName("nnmdhhumfxqwehue")
    public suspend fun prefixMatch(`value`: Output<List<String>>) {
        this.prefixMatch = value
    }

    @JvmName("fimjclregkphwsjb")
    public suspend fun prefixMatch(vararg values: Output<String>) {
        this.prefixMatch = Output.all(values.asList())
    }

    /**
     * @param values An array of strings for prefixes to be match.
     */
    @JvmName("litdybhersdggdwy")
    public suspend fun prefixMatch(values: List<Output<String>>) {
        this.prefixMatch = Output.all(values)
    }

    /**
     * @param value An array of blob index tag based filters, there can be at most 10 tag filters
     */
    @JvmName("fvjxokwfowcklwfx")
    public suspend fun blobIndexMatch(`value`: List<TagFilterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blobIndexMatch = mapped
    }

    /**
     * @param argument An array of blob index tag based filters, there can be at most 10 tag filters
     */
    @JvmName("unhefalfjonnbigw")
    public suspend fun blobIndexMatch(argument: List<suspend TagFilterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { TagFilterArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.blobIndexMatch = mapped
    }

    /**
     * @param argument An array of blob index tag based filters, there can be at most 10 tag filters
     */
    @JvmName("lybfipmycewmonwq")
    public suspend fun blobIndexMatch(vararg argument: suspend TagFilterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { TagFilterArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.blobIndexMatch = mapped
    }

    /**
     * @param argument An array of blob index tag based filters, there can be at most 10 tag filters
     */
    @JvmName("eaqnexkuvtdnvbmg")
    public suspend fun blobIndexMatch(argument: suspend TagFilterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TagFilterArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.blobIndexMatch = mapped
    }

    /**
     * @param values An array of blob index tag based filters, there can be at most 10 tag filters
     */
    @JvmName("bpivaomnlmagknmb")
    public suspend fun blobIndexMatch(vararg values: TagFilterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.blobIndexMatch = mapped
    }

    /**
     * @param value An array of predefined enum values. Currently blockBlob supports all tiering and delete actions. Only delete actions are supported for appendBlob.
     */
    @JvmName("vodphkfeoqlqskab")
    public suspend fun blobTypes(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.blobTypes = mapped
    }

    /**
     * @param values An array of predefined enum values. Currently blockBlob supports all tiering and delete actions. Only delete actions are supported for appendBlob.
     */
    @JvmName("uoqpgoaffrejjrvn")
    public suspend fun blobTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.blobTypes = mapped
    }

    /**
     * @param value An array of strings for prefixes to be match.
     */
    @JvmName("wwikhfvilsubnogy")
    public suspend fun prefixMatch(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefixMatch = mapped
    }

    /**
     * @param values An array of strings for prefixes to be match.
     */
    @JvmName("hgubguumntcvdwlo")
    public suspend fun prefixMatch(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.prefixMatch = mapped
    }

    internal fun build(): ManagementPolicyFilterArgs = ManagementPolicyFilterArgs(
        blobIndexMatch = blobIndexMatch,
        blobTypes = blobTypes ?: throw PulumiNullFieldException("blobTypes"),
        prefixMatch = prefixMatch,
    )
}
