@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.MultichannelArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Multichannel setting. Applies to Premium FileStorage only.
 * @property enabled Indicates whether multichannel is enabled
 */
public data class MultichannelArgs(
    public val enabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.MultichannelArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.MultichannelArgs =
        com.pulumi.azurenative.storage.inputs.MultichannelArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MultichannelArgs].
 */
@PulumiTagMarker
public class MultichannelArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    /**
     * @param value Indicates whether multichannel is enabled
     */
    @JvmName("dogibrwjghwiyggc")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Indicates whether multichannel is enabled
     */
    @JvmName("qkoumfipdpnpqhre")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): MultichannelArgs = MultichannelArgs(
        enabled = enabled,
    )
}
