@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.NetworkRuleSetArgs.builder
import com.pulumi.azurenative.storage.kotlin.enums.Bypass
import com.pulumi.azurenative.storage.kotlin.enums.DefaultAction
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Network rule set
 * @property bypass Specifies whether traffic is bypassed for Logging/Metrics/AzureServices. Possible values are any combination of Logging|Metrics|AzureServices (For example, "Logging, Metrics"), or None to bypass none of those traffics.
 * @property defaultAction Specifies the default action of allow or deny when no other rules match.
 * @property ipRules Sets the IP ACL rules
 * @property resourceAccessRules Sets the resource access rules
 * @property virtualNetworkRules Sets the virtual network rules
 */
public data class NetworkRuleSetArgs(
    public val bypass: Output<Either<String, Bypass>>? = null,
    public val defaultAction: Output<DefaultAction>,
    public val ipRules: Output<List<IPRuleArgs>>? = null,
    public val resourceAccessRules: Output<List<ResourceAccessRuleArgs>>? = null,
    public val virtualNetworkRules: Output<List<VirtualNetworkRuleArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.NetworkRuleSetArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.NetworkRuleSetArgs =
        com.pulumi.azurenative.storage.inputs.NetworkRuleSetArgs.builder()
            .bypass(
                bypass?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .defaultAction(defaultAction.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ipRules(
                ipRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceAccessRules(
                resourceAccessRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .virtualNetworkRules(
                virtualNetworkRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [NetworkRuleSetArgs].
 */
@PulumiTagMarker
public class NetworkRuleSetArgsBuilder internal constructor() {
    private var bypass: Output<Either<String, Bypass>>? = null

    private var defaultAction: Output<DefaultAction>? = null

    private var ipRules: Output<List<IPRuleArgs>>? = null

    private var resourceAccessRules: Output<List<ResourceAccessRuleArgs>>? = null

    private var virtualNetworkRules: Output<List<VirtualNetworkRuleArgs>>? = null

    /**
     * @param value Specifies whether traffic is bypassed for Logging/Metrics/AzureServices. Possible values are any combination of Logging|Metrics|AzureServices (For example, "Logging, Metrics"), or None to bypass none of those traffics.
     */
    @JvmName("scrtqoongaccnlvg")
    public suspend fun bypass(`value`: Output<Either<String, Bypass>>) {
        this.bypass = value
    }

    /**
     * @param value Specifies the default action of allow or deny when no other rules match.
     */
    @JvmName("vxjuohtlcubhafvp")
    public suspend fun defaultAction(`value`: Output<DefaultAction>) {
        this.defaultAction = value
    }

    /**
     * @param value Sets the IP ACL rules
     */
    @JvmName("cegossabfmrdwxey")
    public suspend fun ipRules(`value`: Output<List<IPRuleArgs>>) {
        this.ipRules = value
    }

    @JvmName("odgiswwxcumfisrs")
    public suspend fun ipRules(vararg values: Output<IPRuleArgs>) {
        this.ipRules = Output.all(values.asList())
    }

    /**
     * @param values Sets the IP ACL rules
     */
    @JvmName("lekyhnrywadvmnxx")
    public suspend fun ipRules(values: List<Output<IPRuleArgs>>) {
        this.ipRules = Output.all(values)
    }

    /**
     * @param value Sets the resource access rules
     */
    @JvmName("etibdvxtqulxrnsg")
    public suspend fun resourceAccessRules(`value`: Output<List<ResourceAccessRuleArgs>>) {
        this.resourceAccessRules = value
    }

    @JvmName("ntkjmucyynyjwlbc")
    public suspend fun resourceAccessRules(vararg values: Output<ResourceAccessRuleArgs>) {
        this.resourceAccessRules = Output.all(values.asList())
    }

    /**
     * @param values Sets the resource access rules
     */
    @JvmName("intxfxlnbyhmbccc")
    public suspend fun resourceAccessRules(values: List<Output<ResourceAccessRuleArgs>>) {
        this.resourceAccessRules = Output.all(values)
    }

    /**
     * @param value Sets the virtual network rules
     */
    @JvmName("nmjibjdepogbnkhb")
    public suspend fun virtualNetworkRules(`value`: Output<List<VirtualNetworkRuleArgs>>) {
        this.virtualNetworkRules = value
    }

    @JvmName("tsvetfexybjeppto")
    public suspend fun virtualNetworkRules(vararg values: Output<VirtualNetworkRuleArgs>) {
        this.virtualNetworkRules = Output.all(values.asList())
    }

    /**
     * @param values Sets the virtual network rules
     */
    @JvmName("tgfvfrrnkiehxsan")
    public suspend fun virtualNetworkRules(values: List<Output<VirtualNetworkRuleArgs>>) {
        this.virtualNetworkRules = Output.all(values)
    }

    /**
     * @param value Specifies whether traffic is bypassed for Logging/Metrics/AzureServices. Possible values are any combination of Logging|Metrics|AzureServices (For example, "Logging, Metrics"), or None to bypass none of those traffics.
     */
    @JvmName("gxbanpgljenvollv")
    public suspend fun bypass(`value`: Either<String, Bypass>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bypass = mapped
    }

    /**
     * @param value Specifies whether traffic is bypassed for Logging/Metrics/AzureServices. Possible values are any combination of Logging|Metrics|AzureServices (For example, "Logging, Metrics"), or None to bypass none of those traffics.
     */
    @JvmName("oqguuvksqcynwlxy")
    public fun bypass(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Bypass>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bypass = mapped
    }

    /**
     * @param value Specifies whether traffic is bypassed for Logging/Metrics/AzureServices. Possible values are any combination of Logging|Metrics|AzureServices (For example, "Logging, Metrics"), or None to bypass none of those traffics.
     */
    @JvmName("ecgumuldvqqouamm")
    public fun bypass(`value`: Bypass) {
        val toBeMapped = Either.ofRight<String, Bypass>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bypass = mapped
    }

    /**
     * @param value Specifies the default action of allow or deny when no other rules match.
     */
    @JvmName("narppxcfssytuqnk")
    public suspend fun defaultAction(`value`: DefaultAction) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultAction = mapped
    }

    /**
     * @param value Sets the IP ACL rules
     */
    @JvmName("kvlabmgckyhktjcr")
    public suspend fun ipRules(`value`: List<IPRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipRules = mapped
    }

    /**
     * @param argument Sets the IP ACL rules
     */
    @JvmName("lugluujpjkmoumle")
    public suspend fun ipRules(argument: List<suspend IPRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { IPRuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ipRules = mapped
    }

    /**
     * @param argument Sets the IP ACL rules
     */
    @JvmName("hrshdrckcfryjibc")
    public suspend fun ipRules(vararg argument: suspend IPRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { IPRuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ipRules = mapped
    }

    /**
     * @param argument Sets the IP ACL rules
     */
    @JvmName("ykfgqncrxrgurtpd")
    public suspend fun ipRules(argument: suspend IPRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IPRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ipRules = mapped
    }

    /**
     * @param values Sets the IP ACL rules
     */
    @JvmName("oyycodjddpxaqggs")
    public suspend fun ipRules(vararg values: IPRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipRules = mapped
    }

    /**
     * @param value Sets the resource access rules
     */
    @JvmName("oiyktsvgdyklttnv")
    public suspend fun resourceAccessRules(`value`: List<ResourceAccessRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceAccessRules = mapped
    }

    /**
     * @param argument Sets the resource access rules
     */
    @JvmName("hjmvctpbjvesdrcn")
    public suspend
    fun resourceAccessRules(argument: List<suspend ResourceAccessRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ResourceAccessRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceAccessRules = mapped
    }

    /**
     * @param argument Sets the resource access rules
     */
    @JvmName("yxgjpvfwonsihdoq")
    public suspend fun resourceAccessRules(
        vararg
        argument: suspend ResourceAccessRuleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ResourceAccessRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceAccessRules = mapped
    }

    /**
     * @param argument Sets the resource access rules
     */
    @JvmName("xjyoytnadcaksqrx")
    public suspend
    fun resourceAccessRules(argument: suspend ResourceAccessRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ResourceAccessRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.resourceAccessRules = mapped
    }

    /**
     * @param values Sets the resource access rules
     */
    @JvmName("gmsctwusasgaogaf")
    public suspend fun resourceAccessRules(vararg values: ResourceAccessRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceAccessRules = mapped
    }

    /**
     * @param value Sets the virtual network rules
     */
    @JvmName("bcgemludxcdvodlr")
    public suspend fun virtualNetworkRules(`value`: List<VirtualNetworkRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworkRules = mapped
    }

    /**
     * @param argument Sets the virtual network rules
     */
    @JvmName("slwkppgoispcokrg")
    public suspend
    fun virtualNetworkRules(argument: List<suspend VirtualNetworkRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualNetworkRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.virtualNetworkRules = mapped
    }

    /**
     * @param argument Sets the virtual network rules
     */
    @JvmName("vfvwoamitsoonmfo")
    public suspend fun virtualNetworkRules(
        vararg
        argument: suspend VirtualNetworkRuleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VirtualNetworkRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.virtualNetworkRules = mapped
    }

    /**
     * @param argument Sets the virtual network rules
     */
    @JvmName("vqsfjtgaokugdxga")
    public suspend
    fun virtualNetworkRules(argument: suspend VirtualNetworkRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VirtualNetworkRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.virtualNetworkRules = mapped
    }

    /**
     * @param values Sets the virtual network rules
     */
    @JvmName("vsnjdodrovnyyire")
    public suspend fun virtualNetworkRules(vararg values: VirtualNetworkRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualNetworkRules = mapped
    }

    internal fun build(): NetworkRuleSetArgs = NetworkRuleSetArgs(
        bypass = bypass,
        defaultAction = defaultAction ?: throw PulumiNullFieldException("defaultAction"),
        ipRules = ipRules,
        resourceAccessRules = resourceAccessRules,
        virtualNetworkRules = virtualNetworkRules,
    )
}
