@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.RoutingPreferenceArgs.builder
import com.pulumi.azurenative.storage.kotlin.enums.RoutingChoice
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Routing preference defines the type of network, either microsoft or internet routing to be used to deliver the user data, the default option is microsoft routing
 * @property publishInternetEndpoints A boolean flag which indicates whether internet routing storage endpoints are to be published
 * @property publishMicrosoftEndpoints A boolean flag which indicates whether microsoft routing storage endpoints are to be published
 * @property routingChoice Routing Choice defines the kind of network routing opted by the user.
 */
public data class RoutingPreferenceArgs(
    public val publishInternetEndpoints: Output<Boolean>? = null,
    public val publishMicrosoftEndpoints: Output<Boolean>? = null,
    public val routingChoice: Output<Either<String, RoutingChoice>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.RoutingPreferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.RoutingPreferenceArgs =
        com.pulumi.azurenative.storage.inputs.RoutingPreferenceArgs.builder()
            .publishInternetEndpoints(publishInternetEndpoints?.applyValue({ args0 -> args0 }))
            .publishMicrosoftEndpoints(publishMicrosoftEndpoints?.applyValue({ args0 -> args0 }))
            .routingChoice(
                routingChoice?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [RoutingPreferenceArgs].
 */
@PulumiTagMarker
public class RoutingPreferenceArgsBuilder internal constructor() {
    private var publishInternetEndpoints: Output<Boolean>? = null

    private var publishMicrosoftEndpoints: Output<Boolean>? = null

    private var routingChoice: Output<Either<String, RoutingChoice>>? = null

    /**
     * @param value A boolean flag which indicates whether internet routing storage endpoints are to be published
     */
    @JvmName("nuxjkuifulwopptj")
    public suspend fun publishInternetEndpoints(`value`: Output<Boolean>) {
        this.publishInternetEndpoints = value
    }

    /**
     * @param value A boolean flag which indicates whether microsoft routing storage endpoints are to be published
     */
    @JvmName("mvesjsnbfsbiruid")
    public suspend fun publishMicrosoftEndpoints(`value`: Output<Boolean>) {
        this.publishMicrosoftEndpoints = value
    }

    /**
     * @param value Routing Choice defines the kind of network routing opted by the user.
     */
    @JvmName("fvmyieqlrkefnqnl")
    public suspend fun routingChoice(`value`: Output<Either<String, RoutingChoice>>) {
        this.routingChoice = value
    }

    /**
     * @param value A boolean flag which indicates whether internet routing storage endpoints are to be published
     */
    @JvmName("ljbqvsydwwkdshrp")
    public suspend fun publishInternetEndpoints(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publishInternetEndpoints = mapped
    }

    /**
     * @param value A boolean flag which indicates whether microsoft routing storage endpoints are to be published
     */
    @JvmName("sesrpgxirvyrdtan")
    public suspend fun publishMicrosoftEndpoints(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publishMicrosoftEndpoints = mapped
    }

    /**
     * @param value Routing Choice defines the kind of network routing opted by the user.
     */
    @JvmName("iuggecbqtxxwxkds")
    public suspend fun routingChoice(`value`: Either<String, RoutingChoice>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routingChoice = mapped
    }

    /**
     * @param value Routing Choice defines the kind of network routing opted by the user.
     */
    @JvmName("aaauaktoossvdpuk")
    public fun routingChoice(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RoutingChoice>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routingChoice = mapped
    }

    /**
     * @param value Routing Choice defines the kind of network routing opted by the user.
     */
    @JvmName("sfkafxilnxqhmqkt")
    public fun routingChoice(`value`: RoutingChoice) {
        val toBeMapped = Either.ofRight<String, RoutingChoice>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routingChoice = mapped
    }

    internal fun build(): RoutingPreferenceArgs = RoutingPreferenceArgs(
        publishInternetEndpoints = publishInternetEndpoints,
        publishMicrosoftEndpoints = publishMicrosoftEndpoints,
        routingChoice = routingChoice,
    )
}
