@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * An object that wraps the blob inventory rule. Each rule is uniquely defined by name.
 * @property definition An object that defines the blob inventory policy rule.
 * @property destination Container name where blob inventory files are stored. Must be pre-created.
 * @property enabled Rule is enabled when set to true.
 * @property name A rule name can contain any combination of alpha numeric characters. Rule name is case-sensitive. It must be unique within a policy.
 */
public data class BlobInventoryPolicyRuleResponse(
    public val definition: BlobInventoryPolicyDefinitionResponse,
    public val destination: String,
    public val enabled: Boolean,
    public val name: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.BlobInventoryPolicyRuleResponse):
            BlobInventoryPolicyRuleResponse = BlobInventoryPolicyRuleResponse(
            definition = javaType.definition().let({ args0 ->
                com.pulumi.azurenative.storage.kotlin.outputs.BlobInventoryPolicyDefinitionResponse.Companion.toKotlin(args0)
            }),
            destination = javaType.destination(),
            enabled = javaType.enabled(),
            name = javaType.name(),
        )
    }
}
