@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

/**
 * The blob service properties for change feed events.
 * @property enabled Indicates whether change feed event logging is enabled for the Blob service.
 * @property retentionInDays Indicates the duration of changeFeed retention in days. Minimum value is 1 day and maximum value is 146000 days (400 years). A null value indicates an infinite retention of the change feed.
 */
public data class ChangeFeedResponse(
    public val enabled: Boolean? = null,
    public val retentionInDays: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.ChangeFeedResponse):
            ChangeFeedResponse = ChangeFeedResponse(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            retentionInDays = javaType.retentionInDays().map({ args0 -> args0 }).orElse(null),
        )
    }
}
