@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.Double
import kotlin.Suppress

/**
 * Object to define snapshot and version action conditions.
 * @property daysAfterCreationGreaterThan Value indicating the age in days after creation
 * @property daysAfterLastTierChangeGreaterThan Value indicating the age in days after last blob tier change time. This property is only applicable for tierToArchive actions and requires daysAfterCreationGreaterThan to be set for snapshots and blob version based actions. The blob will be archived if both the conditions are satisfied.
 */
public data class DateAfterCreationResponse(
    public val daysAfterCreationGreaterThan: Double,
    public val daysAfterLastTierChangeGreaterThan: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.DateAfterCreationResponse):
            DateAfterCreationResponse = DateAfterCreationResponse(
            daysAfterCreationGreaterThan = javaType.daysAfterCreationGreaterThan(),
            daysAfterLastTierChangeGreaterThan = javaType.daysAfterLastTierChangeGreaterThan().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
