@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The URIs that are used to perform a retrieval of a public blob, queue, table, web or dfs object.
 * @property blob Gets the blob endpoint.
 * @property dfs Gets the dfs endpoint.
 * @property file Gets the file endpoint.
 * @property internetEndpoints Gets the internet routing storage endpoints
 * @property microsoftEndpoints Gets the microsoft routing storage endpoints.
 * @property queue Gets the queue endpoint.
 * @property table Gets the table endpoint.
 * @property web Gets the web endpoint.
 */
public data class EndpointsResponse(
    public val blob: String,
    public val dfs: String,
    public val `file`: String,
    public val internetEndpoints: StorageAccountInternetEndpointsResponse? = null,
    public val microsoftEndpoints: StorageAccountMicrosoftEndpointsResponse? = null,
    public val queue: String,
    public val table: String,
    public val web: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.EndpointsResponse):
            EndpointsResponse = EndpointsResponse(
            blob = javaType.blob(),
            dfs = javaType.dfs(),
            `file` = javaType.`file`(),
            internetEndpoints = javaType.internetEndpoints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.StorageAccountInternetEndpointsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            microsoftEndpoints = javaType.microsoftEndpoints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.StorageAccountMicrosoftEndpointsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            queue = javaType.queue(),
            table = javaType.table(),
            web = javaType.web(),
        )
    }
}
