@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * Multichannel setting. Applies to Premium FileStorage only.
 * @property enabled Indicates whether multichannel is enabled
 */
public data class MultichannelResponse(
    public val enabled: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.MultichannelResponse):
            MultichannelResponse = MultichannelResponse(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
        )
    }
}
