@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Filters limit replication to a subset of blobs within the storage account. A logical OR is performed on values in the filter. If multiple filters are defined, a logical AND is performed on all filters.
 * @property minCreationTime Blobs created after the time will be replicated to the destination. It must be in datetime format 'yyyy-MM-ddTHH:mm:ssZ'. Example: 2020-02-19T16:05:00Z
 * @property prefixMatch Optional. Filters the results to replicate only blobs whose names begin with the specified prefix.
 */
public data class ObjectReplicationPolicyFilterResponse(
    public val minCreationTime: String? = null,
    public val prefixMatch: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.ObjectReplicationPolicyFilterResponse):
            ObjectReplicationPolicyFilterResponse = ObjectReplicationPolicyFilterResponse(
            minCreationTime = javaType.minCreationTime().map({ args0 -> args0 }).orElse(null),
            prefixMatch = javaType.prefixMatch().map({ args0 -> args0 }),
        )
    }
}
