@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The replication policy rule between two containers.
 * @property destinationContainer Required. Destination container name.
 * @property filters Optional. An object that defines the filter set.
 * @property ruleId Rule Id is auto-generated for each new rule on destination account. It is required for put policy on source account.
 * @property sourceContainer Required. Source container name.
 */
public data class ObjectReplicationPolicyRuleResponse(
    public val destinationContainer: String,
    public val filters: ObjectReplicationPolicyFilterResponse? = null,
    public val ruleId: String? = null,
    public val sourceContainer: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.ObjectReplicationPolicyRuleResponse):
            ObjectReplicationPolicyRuleResponse = ObjectReplicationPolicyRuleResponse(
            destinationContainer = javaType.destinationContainer(),
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.ObjectReplicationPolicyFilterResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            ruleId = javaType.ruleId().map({ args0 -> args0 }).orElse(null),
            sourceContainer = javaType.sourceContainer(),
        )
    }
}
