@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property permissions The permissions for the local user. Possible values include: Read (r), Write (w), Delete (d), List (l), and Create (c).
 * @property resourceName The name of resource, normally the container name or the file share name, used by the local user.
 * @property service The service used by the local user, e.g. blob, file.
 */
public data class PermissionScopeResponse(
    public val permissions: String,
    public val resourceName: String,
    public val service: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.PermissionScopeResponse):
            PermissionScopeResponse = PermissionScopeResponse(
            permissions = javaType.permissions(),
            resourceName = javaType.resourceName(),
            service = javaType.service(),
        )
    }
}
