@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Protected append writes history setting for the blob container with Legal holds.
 * @property allowProtectedAppendWritesAll When enabled, new blocks can be written to both 'Append and Bock Blobs' while maintaining legal hold protection and compliance. Only new blocks can be added and any existing blocks cannot be modified or deleted.
 * @property timestamp Returns the date and time the tag was added.
 */
public data class ProtectedAppendWritesHistoryResponse(
    public val allowProtectedAppendWritesAll: Boolean? = null,
    public val timestamp: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.ProtectedAppendWritesHistoryResponse):
            ProtectedAppendWritesHistoryResponse = ProtectedAppendWritesHistoryResponse(
            allowProtectedAppendWritesAll = javaType.allowProtectedAppendWritesAll().map({ args0 ->
                args0
            }).orElse(null),
            timestamp = javaType.timestamp(),
        )
    }
}
