@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storageactions.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Represents an operation to be performed on the object
 * @property name The operation to be performed on the object.
 * @property onFailure Action to be taken when the operation fails for a object.
 * @property onSuccess Action to be taken when the operation is successful for a object.
 * @property parameters Key-value parameters for the operation.
 */
public data class StorageTaskOperationResponse(
    public val name: String,
    public val onFailure: String? = null,
    public val onSuccess: String? = null,
    public val parameters: Map<String, String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storageactions.outputs.StorageTaskOperationResponse):
            StorageTaskOperationResponse = StorageTaskOperationResponse(
            name = javaType.name(),
            onFailure = javaType.onFailure().map({ args0 -> args0 }).orElse(null),
            onSuccess = javaType.onSuccess().map({ args0 -> args0 }).orElse(null),
            parameters = javaType.parameters().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
