@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.inputs

import com.pulumi.azurenative.storagecache.inputs.AmlFilesystemEncryptionSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * AML file system encryption settings.
 * @property keyEncryptionKey Specifies the location of the encryption key in Key Vault.
 */
public data class AmlFilesystemEncryptionSettingsArgs(
    public val keyEncryptionKey: Output<KeyVaultKeyReferenceArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.storagecache.inputs.AmlFilesystemEncryptionSettingsArgs> {
    override fun toJava():
        com.pulumi.azurenative.storagecache.inputs.AmlFilesystemEncryptionSettingsArgs =
        com.pulumi.azurenative.storagecache.inputs.AmlFilesystemEncryptionSettingsArgs.builder()
            .keyEncryptionKey(
                keyEncryptionKey?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [AmlFilesystemEncryptionSettingsArgs].
 */
@PulumiTagMarker
public class AmlFilesystemEncryptionSettingsArgsBuilder internal constructor() {
    private var keyEncryptionKey: Output<KeyVaultKeyReferenceArgs>? = null

    /**
     * @param value Specifies the location of the encryption key in Key Vault.
     */
    @JvmName("pqktqogmhwjqdrqo")
    public suspend fun keyEncryptionKey(`value`: Output<KeyVaultKeyReferenceArgs>) {
        this.keyEncryptionKey = value
    }

    /**
     * @param value Specifies the location of the encryption key in Key Vault.
     */
    @JvmName("ciartnxqlolunkcp")
    public suspend fun keyEncryptionKey(`value`: KeyVaultKeyReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyEncryptionKey = mapped
    }

    /**
     * @param argument Specifies the location of the encryption key in Key Vault.
     */
    @JvmName("meaqaqguyycmqfok")
    public suspend
    fun keyEncryptionKey(argument: suspend KeyVaultKeyReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = KeyVaultKeyReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.keyEncryptionKey = mapped
    }

    internal fun build(): AmlFilesystemEncryptionSettingsArgs = AmlFilesystemEncryptionSettingsArgs(
        keyEncryptionKey = keyEncryptionKey,
    )
}
