@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.inputs

import com.pulumi.azurenative.storagecache.inputs.CacheActiveDirectorySettingsCredentialsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Active Directory admin credentials used to join the HPC Cache to a domain.
 * @property password Plain text password of the Active Directory domain administrator. This value is stored encrypted and not returned on response.
 * @property username Username of the Active Directory domain administrator. This value is stored encrypted and not returned on response.
 */
public data class CacheActiveDirectorySettingsCredentialsArgs(
    public val password: Output<String>? = null,
    public val username: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.storagecache.inputs.CacheActiveDirectorySettingsCredentialsArgs> {
    override fun toJava():
        com.pulumi.azurenative.storagecache.inputs.CacheActiveDirectorySettingsCredentialsArgs =
        com.pulumi.azurenative.storagecache.inputs.CacheActiveDirectorySettingsCredentialsArgs.builder()
            .password(password?.applyValue({ args0 -> args0 }))
            .username(username.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CacheActiveDirectorySettingsCredentialsArgs].
 */
@PulumiTagMarker
public class CacheActiveDirectorySettingsCredentialsArgsBuilder internal constructor() {
    private var password: Output<String>? = null

    private var username: Output<String>? = null

    /**
     * @param value Plain text password of the Active Directory domain administrator. This value is stored encrypted and not returned on response.
     */
    @JvmName("knfiwxoouuwdxdfy")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value Username of the Active Directory domain administrator. This value is stored encrypted and not returned on response.
     */
    @JvmName("pbfegtbqcbnrgntj")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value Plain text password of the Active Directory domain administrator. This value is stored encrypted and not returned on response.
     */
    @JvmName("ebxwdhvslqltpeyh")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Username of the Active Directory domain administrator. This value is stored encrypted and not returned on response.
     */
    @JvmName("cngsrfollmpcsprs")
    public suspend fun username(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): CacheActiveDirectorySettingsCredentialsArgs =
        CacheActiveDirectorySettingsCredentialsArgs(
            password = password,
            username = username ?: throw PulumiNullFieldException("username"),
        )
}
