@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.inputs

import com.pulumi.azurenative.storagecache.inputs.CacheDirectorySettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Cache Directory Services settings.
 * @property activeDirectory Specifies settings for joining the HPC Cache to an Active Directory domain.
 * @property usernameDownload Specifies settings for Extended Groups. Extended Groups allows users to be members of more than 16 groups.
 */
public data class CacheDirectorySettingsArgs(
    public val activeDirectory: Output<CacheActiveDirectorySettingsArgs>? = null,
    public val usernameDownload: Output<CacheUsernameDownloadSettingsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storagecache.inputs.CacheDirectorySettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.storagecache.inputs.CacheDirectorySettingsArgs =
        com.pulumi.azurenative.storagecache.inputs.CacheDirectorySettingsArgs.builder()
            .activeDirectory(activeDirectory?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .usernameDownload(
                usernameDownload?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [CacheDirectorySettingsArgs].
 */
@PulumiTagMarker
public class CacheDirectorySettingsArgsBuilder internal constructor() {
    private var activeDirectory: Output<CacheActiveDirectorySettingsArgs>? = null

    private var usernameDownload: Output<CacheUsernameDownloadSettingsArgs>? = null

    /**
     * @param value Specifies settings for joining the HPC Cache to an Active Directory domain.
     */
    @JvmName("tioavmjqieklbcqt")
    public suspend fun activeDirectory(`value`: Output<CacheActiveDirectorySettingsArgs>) {
        this.activeDirectory = value
    }

    /**
     * @param value Specifies settings for Extended Groups. Extended Groups allows users to be members of more than 16 groups.
     */
    @JvmName("incwcidejtvsaeil")
    public suspend fun usernameDownload(`value`: Output<CacheUsernameDownloadSettingsArgs>) {
        this.usernameDownload = value
    }

    /**
     * @param value Specifies settings for joining the HPC Cache to an Active Directory domain.
     */
    @JvmName("dkojjouvblptunmn")
    public suspend fun activeDirectory(`value`: CacheActiveDirectorySettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.activeDirectory = mapped
    }

    /**
     * @param argument Specifies settings for joining the HPC Cache to an Active Directory domain.
     */
    @JvmName("nllsllmwngotwaqc")
    public suspend
    fun activeDirectory(argument: suspend CacheActiveDirectorySettingsArgsBuilder.() -> Unit) {
        val toBeMapped = CacheActiveDirectorySettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.activeDirectory = mapped
    }

    /**
     * @param value Specifies settings for Extended Groups. Extended Groups allows users to be members of more than 16 groups.
     */
    @JvmName("mhuokwbffcbtmvba")
    public suspend fun usernameDownload(`value`: CacheUsernameDownloadSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usernameDownload = mapped
    }

    /**
     * @param argument Specifies settings for Extended Groups. Extended Groups allows users to be members of more than 16 groups.
     */
    @JvmName("erwsevfwecewyaya")
    public suspend
    fun usernameDownload(argument: suspend CacheUsernameDownloadSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = CacheUsernameDownloadSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.usernameDownload = mapped
    }

    internal fun build(): CacheDirectorySettingsArgs = CacheDirectorySettingsArgs(
        activeDirectory = activeDirectory,
        usernameDownload = usernameDownload,
    )
}
