@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.inputs

import com.pulumi.azurenative.storagecache.inputs.CacheSecuritySettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Cache security settings.
 * @property accessPolicies NFS access policies defined for this cache.
 */
public data class CacheSecuritySettingsArgs(
    public val accessPolicies: Output<List<NfsAccessPolicyArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storagecache.inputs.CacheSecuritySettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.storagecache.inputs.CacheSecuritySettingsArgs =
        com.pulumi.azurenative.storagecache.inputs.CacheSecuritySettingsArgs.builder()
            .accessPolicies(
                accessPolicies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [CacheSecuritySettingsArgs].
 */
@PulumiTagMarker
public class CacheSecuritySettingsArgsBuilder internal constructor() {
    private var accessPolicies: Output<List<NfsAccessPolicyArgs>>? = null

    /**
     * @param value NFS access policies defined for this cache.
     */
    @JvmName("ajodqyholpkabgpt")
    public suspend fun accessPolicies(`value`: Output<List<NfsAccessPolicyArgs>>) {
        this.accessPolicies = value
    }

    @JvmName("xhpifowhvfpnpimj")
    public suspend fun accessPolicies(vararg values: Output<NfsAccessPolicyArgs>) {
        this.accessPolicies = Output.all(values.asList())
    }

    /**
     * @param values NFS access policies defined for this cache.
     */
    @JvmName("cstpgwpmptfgkjdi")
    public suspend fun accessPolicies(values: List<Output<NfsAccessPolicyArgs>>) {
        this.accessPolicies = Output.all(values)
    }

    /**
     * @param value NFS access policies defined for this cache.
     */
    @JvmName("jkanakpdckxigvii")
    public suspend fun accessPolicies(`value`: List<NfsAccessPolicyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessPolicies = mapped
    }

    /**
     * @param argument NFS access policies defined for this cache.
     */
    @JvmName("xauhqpculysejqnf")
    public suspend fun accessPolicies(argument: List<suspend NfsAccessPolicyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NfsAccessPolicyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.accessPolicies = mapped
    }

    /**
     * @param argument NFS access policies defined for this cache.
     */
    @JvmName("cxfftdjsqnfptbsp")
    public suspend fun accessPolicies(
        vararg
        argument: suspend NfsAccessPolicyArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            NfsAccessPolicyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.accessPolicies = mapped
    }

    /**
     * @param argument NFS access policies defined for this cache.
     */
    @JvmName("ydyjlmlrmssbldgi")
    public suspend fun accessPolicies(argument: suspend NfsAccessPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(NfsAccessPolicyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.accessPolicies = mapped
    }

    /**
     * @param values NFS access policies defined for this cache.
     */
    @JvmName("nfaptoafynbntqwm")
    public suspend fun accessPolicies(vararg values: NfsAccessPolicyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessPolicies = mapped
    }

    internal fun build(): CacheSecuritySettingsArgs = CacheSecuritySettingsArgs(
        accessPolicies = accessPolicies,
    )
}
