@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.inputs

import com.pulumi.azurenative.storagecache.inputs.GetCachePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cacheName Name of cache. Length of name must not be greater than 80 and chars must be from the [-0-9a-zA-Z_] char class.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetCachePlainArgs(
    public val cacheName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.storagecache.inputs.GetCachePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.storagecache.inputs.GetCachePlainArgs =
        com.pulumi.azurenative.storagecache.inputs.GetCachePlainArgs.builder()
            .cacheName(cacheName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCachePlainArgs].
 */
@PulumiTagMarker
public class GetCachePlainArgsBuilder internal constructor() {
    private var cacheName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of cache. Length of name must not be greater than 80 and chars must be from the [-0-9a-zA-Z_] char class.
     */
    @JvmName("dcnnuueqkynsdoui")
    public suspend fun cacheName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.cacheName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mjknwpympyhwxaan")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetCachePlainArgs = GetCachePlainArgs(
        cacheName = cacheName ?: throw PulumiNullFieldException("cacheName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
